;------------------------------------------------------------------------------

ADLIB_ADDR	equ 388h	;AdLib output port addr.

;------------------------------------------------------------------------------
;MIDI play variables
;------------------------------------------------------------------------------

TicksPQ		dw 96		;ticks per quarter note (Std.96)

;VoiceNotes array gives for each voice
;the note last played or 0 if off.

VoiceNotes	db 11 dup (0)

;VoiceStatus array gives for each voice
;the time voice was played
;or 0 if voice is off

VoiceStatus	dw 11 dup (0)

;VoiceVolumes array holds the current volume
;for each voice (0-127)

VoiceVolumes	db 11 dup (0)

;ChanVoices gives the allocation of voices
;to MIDI channels for pseudo-polyphony
;
;these are changed each song to the best compromise

ChanNVoices	db 0,0,0,0,0,0,0,0 ;no. of voices for each MIDI channel

ChanVoices	db 0,0,0,0,0,0,0,0	;up to 8 per channel
		db 0,0,0,0,0,0,0,0
		db 0,0,0,0,0,0,0,0
		db 0,0,0,0,0,0,0,0

AdTransposes	db 0,0,0,0,0,0,0,0,0	;transpose for each voice

;voice patches for various songs

SongV0	db 137,137,137,137,137,137,0,0,0

CrntNVoices	dw ChanNVoices
CrntVoices	dw ChanVoices
CrntSPatches	dw SongV0

;percussion voices

BD	equ 6	;bass drum
SD	equ 7	;snare drum
TOM	equ 8	;tom
TC	equ 9	;top cymbal
HH	equ 10	;hi-hat

DrumSounds	db BD,BD,SD,SD,SD,SD,TOM,HH,TOM,HH,TOM,HH,TOM,TOM,TC,TOM,TC,0,0,0,0,0 

;------------------------------------------------------------------------------

PitchBendRange	dw 0		;pitch bend range in semitones

;AdLib global parameters

AmDepth		db 0		;amplitude vib depth
VibDepth	db 0		;vibrato depth
NoteSel		db 0		;key split
Percussion	db 0		;1 for percussion mode

;note variables

Voice		db 0
Note		db 0
PitchBend	dw 0
keyOn		db 0

PercBits	db 0		;keyons for percussion

PerckeyOns	db 10h,8,4,2,1		;BD,SD,TOM,TC,HH
PercPitches	db 10,31,24,40,31	;pitches of percussion

;register addresses on AdLib board

KEYON_BLOCK_FNUM equ 0B0H
FNUM_LOW	 equ 0A0H

;table of frequency no.s for AdLib

FNumTable dw 02B2h,02B4h,02B7h,02B9h,02BCh,02BEh,02C1h,02C3h,02C6h,02C9h
	dw 02CBh,02CEh,02D0h,02D3h,02D6h,02D8h,02DBh,02DDh,02E0h,02E3h 
	dw 02E5h,02E8h,02EBh,02EDh,02F0h,02F3h,02F6h,02F8h,02FBh,02FEh 
	dw 0301h,0303h,0306h,0309h,030Ch,030Fh,0311h,0314h,0317h,031Ah 
	dw 031Dh,0320h,0323h,0326h,0329h,032Bh,032Eh,0331h,0334h,0337h 
	dw 033Ah,033Dh,0340h,0343h,0346h,0349h,034Ch,034Fh,0352h,0356h 
	dw 0359h,035Ch,035Fh,0362h,0365h,0368h,036Bh,036Fh,0372h,0375h 
	dw 0378h,037Bh,037Fh,0382h,0385h,0388h,038Ch,038Fh,0392h,0395h 
	dw 0399h,039Ch,039Fh,03A3h,03A6h,03A9h,03ADh,03B0h,03B4h,03B7h 
	dw 03BBh,03BEh,03C1h,03C5h,03C8h,03CCh,03CFh,03D3h,03D7h,03DAh 
	dw 03DEh,03E1h,03E5h,03E8h,03ECh,03F0h,03F3h,03F7h,03FBh,03FEh 
	dw 0FE01h,0FE03h,0FE05h,0FE07h,0FE08h,0FE0Ah,0FE0Ch,0FE0Eh,0FE10h,0FE12h
	dw 0FE14h,0FE16h,0FE18h,0FE1Ah,0FE1Ch,0FE1Eh,0FE20h,0FE21h,0FE23h,0FE25h 
	dw 0FE27h,0FE29h,0FE2Bh,0FE2Dh,0FE2Fh,0FE31h,0FE34h,0FE36h,0FE38h,0FE3Ah 
	dw 0FE3Ch,0FE3Eh,0FE40h,0FE42h,0FE44h,0FE46h,0FE48h,0FE4Ah,0FE4Ch,0FE4Fh 
	dw 0FE51h,0FE53h,0FE55h,0FE57h,0FE59h,0FE5Ch,0FE5Eh,0FE60h,0FE62h,0FE64h 
	dw 0FE67h,0FE69h,0FE6Bh,0FE6Dh,0FE6Fh,0FE72h,0FE74h,0FE76h,0FE79h,0FE7Bh 
	dw 0FE7Dh,0FE7Fh,0FE82h,0FE84h,0FE86h,0FE89h,0FE8Bh,0FE8Dh,0FE90h,0FE92h 
	dw 0FE95h,0FE97h,0FE99h,0FE9Ch,0FE9Eh,0FEA1h,0FEA3h,0FEA5h,0FEA8h,0FEAAh 
	dw 0FEADh,0FEAFh 

; Integer division by 12 table (96 entries).  It is used to find the octave
; for a given note value in the range [0,95].

DIV12Tab	db 0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1
		db 1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2 
		db 2,2,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4 
		db 4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5 
		db 5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,7 
		db 7,7,7,7,7,7,7,7,7,7,7

; Integer modulo 12 table (96 entries).  It is used to find the half-tone
; value of a note ([0, 95]) within an octave.

MOD12Tab	db 0,1,2,3,4,5,6,7,8,9,10,11,0,1,2,3,4
		db 5,6,7,8,9,10,11,0,1,2,3,4,5,6,7,8,9
		db 10,11,0,1,2,3,4,5,6,7,8,9,10,11,0,1,2
		db 3,4,5,6,7,8,9,10,11,0,1,2,3,4,5,6,7
		db 8,9,10,11,0,1,2,3,4,5,6,7,8,9,10,11,0
		db 1,2,3,4,5,6,7,8,9,10,11

;------------------------------------------------------------

;slot offsets within AdLib

SlotOffsets	db 0,1,2,3,4,5,8,9,10
		db 11,12,13,16,17,18,19,20,21

SlotOffs	db 0	;temporary variable

;slot parameters are:

;0	key scale level		0-3	KSL
;1	freq. multiplier	0-15	MULTI
;2	feedback		0-7	FB
;3	attack rate		0-15	AR
;4	sustain level		0-15	SL
;5	sustaining sound	0-1	EG
;6	decay rate		0-15	DR
;7	release rate		0-15	RR
;8	output level		0-63	TL
;9	amplitude vibrato	0-1	AM
;10	freq. vibrato		0-1	VIB
;11	envelope scaling	0-1	KSR
;12	0=FM 1=Additive synth	0-1	C
;13	wave select		0-3	WS

;global parameters are

;14	amplitude vib. depth	0-1
;15	vib. depth		0-1
;16	note-sel. (split point) 0-1
;17	percussion select	0-1

KSL	equ 0
MULTI	equ 1
FB	equ 2
AR	equ 3
SL	equ 4
EG	equ 5
DR	equ 6
RR	equ 7
TL	equ 8
AM	equ 9
VIB	equ 10
KSR	equ 11
C	equ 12
WS	equ 13



TestNo		dw -1

TestOpr0	db 14 dup (0)
TestOpr1	db 14 dup (0)

;		 KSL MLT FB  AR  SL EG DR  RR  TL AM VB KSR C WS

;default melodic slot parameters

pianoOpr0	db 1,  1, 3, 15,  5, 0, 1,  3, 15, 0, 0, 0, 1, 0
pianoOpr1	db 0,  1, 1, 15,  7, 0, 2,  4,  0, 0, 0, 1, 0, 0

;default percussion slot parameters

bdOpr0		db 0,  0, 0, 10,  4, 0, 8, 12, 11, 0, 0, 0, 1, 0
bdOpr1		db 0,  0, 0, 13,  4, 0, 6, 15,  0, 0, 0, 0, 1, 0

;sdOpr		db 0, 12, 0, 15, 11, 0, 8,  5,  0, 0, 0, 0, 0, 0
sdOpr		db 000h,00Ch,000h,00Ch,00Bh,000h,007h,004h,000h,000h,000h,000h,000h,000h

;tomOpr		db 0,  4, 0, 15, 11, 0, 7,  5,  0, 0, 0, 0, 0, 0
tomOpr		db 000h,002h,000h,00Ch,009h,000h,008h,007h,000h,000h,000h,000h,000h,000h

cymbOpr		db 0,  1, 0, 15, 11, 0, 5,  5,  0, 0, 0, 0, 0, 0

hhOpr		db 000h,001h,004h,00Dh,001h,000h,00Ah,008h,003h,000h,000h,000h,000h,000h

;various melodic patches

AdLibPatches    dw flugel,abass,aclari,aelpia,apian2,apian3
		dw apian4,atromb,atrump,avioli,axylo
		dw astrng,celesta,elpiano1,flute2,solovln
		dw trumpet1,violin1,violin2,violin3
		dw bassstrngl,strnlong


;	   KSL  MLT  FB   AR   SL   EG   DR   RR   TL   AM   VB   KSR  C    WS

;-----------------------------
adbank:
;-----------------------------

flugel	db 02h,01h,06h,04h,09h,01h,01h,06h,14h,01h,01h,00h,01h,00h
	db 02h,01h,62h,04h,04h,01h,01h,05h,00h,00h,01h,00h,01h,00h

;original
;flugel	db 02h,01h,05h,04h,09h,01h,01h,06h,14h,01h,01h,00h,01h,00h
;	db 02h,01h,62h,04h,03h,01h,01h,02h,00h,00h,01h,00h,01h,00h


;flugel
;	db 02h,01h,06h,04h,09h,01h,03h,06h,14h,01h,01h,00h,01h,00h
;	db 02h,01h,62h,0Ah,00h,01h,0Fh,02h,00h,00h,01h,00h,01h,00h


ABass	db 000h,001h,005h,002h,002h,000h,005h,00Fh,015h,000h,000h,000h,001h,000h
	db 002h,001h,005h,006h,006h,001h,005h,00Ch,000h,000h,000h,000h,001h,000h

AClari	db 002h,002h,006h,005h,001h,001h,001h,00Bh,01Ah,000h,000h,001h,001h,000h
	db 002h,001h,003h,00Ah,003h,001h,002h,00Bh,002h,000h,001h,000h,001h,000h

AElPia	db 000h,002h,007h,00Fh,001h,000h,002h,003h,022h,000h,000h,000h,001h,000h
	db 000h,002h,000h,00Fh,004h,000h,005h,003h,000h,000h,000h,000h,001h,000h

APian2	db 002h,001h,003h,00Fh,005h,000h,002h,001h,01Dh,000h,001h,000h,001h,000h
	db 000h,003h,006h,00Fh,00Fh,000h,002h,001h,000h,000h,000h,001h,001h,000h

APian3	db 001h,001h,003h,00Fh,005h,000h,001h,000h,00Fh,000h,000h,000h,001h,000h
	db 000h,001h,004h,00Dh,007h,000h,002h,00Ch,004h,000h,000h,000h,001h,000h

APian4 	db 001h,001h,004h,00Fh,006h,000h,001h,000h,00Dh,000h,000h,000h,001h,000h
	db 000h,001h,004h,00Dh,007h,000h,002h,00Bh,00ah,000h,000h,001h,001h,000h

ATromb	db 000h,001h,007h,007h,001h,001h,001h,00Fh,01Ch,001h,000h,001h,001h,000h
	db 002h,001h,000h,00Bh,003h,001h,002h,00Bh,000h,000h,001h,000h,001h,000h

ATrump	db 000h,001h,007h,004h,000h,001h,001h,00Bh,01Ch,000h,000h,001h,001h,000h
	db 002h,001h,000h,009h,003h,001h,002h,00Bh,000h,000h,001h,000h,001h,000h

AVioli	db 002h,001h,003h,006h,002h,000h,004h,007h,008h,001h,001h,000h,001h,000h
	db 002h,002h,000h,005h,002h,000h,003h,007h,003h,000h,000h,000h,001h,000h

AXylo	db 000h,001h,006h,00Ch,002h,000h,008h,00Fh,02Dh,000h,000h,001h,001h,000h
	db 000h,001h,006h,00Fh,00Fh,001h,005h,005h,000h,000h,000h,001h,001h,000h

AStrng	db 002h,001h,003h,006h,002h,001h,004h,009h,008h,001h,001h,000h,001h,000h
	db 002h,002h,000h,005h,002h,001h,003h,00Ch,003h,000h,000h,000h,001h,000h

;-----------------
;;elite.bnk


celesta	db 02h,03h,04h,00h,01h,01h,01h,00h,07h,00h,00h,01h,01h,00h
	db 02h,04h,62h,07h,03h,00h,0Dh,03h,00h,00h,00h,01h,01h,00h

elpiano1 db 01h,01h,03h,0Fh,05h,00h,01h,00h,0Fh,00h,00h,00h,01h,00h
	db 00h,01h,62h,0Dh,07h,00h,02h,0Ch,04h,00h,00h,00h,01h,00h

flute2	db 03h,00h,07h,06h,08h,01h,0Eh,0Fh,2Ch,01h,01h,00h,01h,00h
	db 00h,01h,62h,06h,02h,01h,05h,0Ah,00h,00h,01h,00h,01h,00h

solovln	db 00h,00h,07h,05h,00h,01h,01h,03h,1Ch,00h,01h,01h,01h,02h
	db 00h,00h,62h,05h,06h,01h,04h,07h,00h,00h,00h,00h,01h,02h

trumpet1 db 00h,01h,07h,04h,00h,01h,01h,0Bh,1Ch,00h,00h,01h,01h,00h
	db 02h,01h,62h,09h,03h,01h,02h,0Bh,00h,00h,01h,00h,01h,00h

violin1	db 00h,01h,07h,05h,00h,01h,01h,03h,1Ch,00h,00h,01h,01h,00h
	db 02h,01h,62h,05h,06h,01h,04h,07h,00h,00h,01h,00h,01h,00h

violin2	db 02h,01h,06h,06h,02h,01h,02h,09h,08h,01h,01h,00h,01h,00h
	db 02h,02h,62h,05h,02h,01h,03h,0Ch,00h,00h,00h,00h,01h,00h

violin3	db 02h,01h,03h,06h,02h,01h,04h,09h,08h,01h,01h,00h,01h,00h
	db 02h,02h,62h,05h,02h,01h,03h,0Ch,03h,00h,00h,00h,01h,00h


bassstrngl db 01h,01h,00h,0Ch,01h,01h,05h,03h,15h,01h,01h,00h,01h,03h
	   db 00h,00h,62h,0Eh,02h,01h,09h,04h,00h,01h,01h,00h,01h,03h

strnlong db 01h,01h,03h,0Fh,00h,01h,01h,03h,0Fh,01h,01h,00h,01h,01h
	 db 00h,01h,62h,0Fh,00h,01h,02h,01h,00h,00h,00h,00h,01h,00h






;slots for voices

VoiceSlots	db 0,3,1,4,2,5,6,9,7,10,8,11,12,15,13,16,14,17
VoiceSlotsPerc	db 0,3,1,4,2,5,6,9,7,10,8,11,12,15,16,-1,14,-1,17,-1,13,-1

