;**************************************************************************
;                                                                         *
; 	PC DRIVER TO RUN MUSIC ON ROLAND/ADLIB 							  *
;									  *
;**************************************************************************
;		--------------------------------

;  The variables :boardflg: and :mode_flag: must be set before calling
;  any of the following procedures

public	do_music		;call to start music playing
public	load_files		;call to load Midi files from current dir.
public  terminate		;call to kill boards
public  fx_mode_on		;call to initiliase driver for ROLAND FX
				;sets up the timer etc.  
public	trigger_fx		;call to start fx.(see list)with number in al

public  boardflg		;byte variable 0 = ROLAND/1 = ADLib
public  mode_flag		;byte variable 0 = MUSIC(both boards)/1 = ROLAND FX

;  examples....
;  if boardflg =1 and mode_flag = 0 then the driver will run MUSIC on ADLIB
;  if boardflg =0 and mode_flag = 1 then driver will run FX on ROLAND
;  if boardflg =0 and mode_flag = 0 then driver will run MUSIC on ROLAND

; 	 ps.. NO FX included in this version

;		--------------------------------

		;    DATA FILES


csongseg1 segment para  'DATA'
MIDIPlayBuffer1 db 3500 dup (?)
csongseg1 ends


csongseg2 segment para  'DATA'
MIDIPlayBuffer2 db 10 dup (?)
csongseg2 ends



fx_segment	segment para  'DATA'
fxd:

fx_segment	ends

;______________________________________________________________________

dseg	segment para 'DATA'

;	messages used for testing /debugging etc...can be deleted
load_mess	db	'loading files...Please Wait',13,10,'$'
board_mess	db	'select which board..R/A',13,10,'$'
mode_mess	db	'                    ',13,10,'$'
fin_mess	db	'1 for DOS/2 to RESELECT',13,10,'$'
fx_mess		db	13,10,' ***********************   KEYS A-z+{ for fx 1 to 27  ***********************',13,10,13,10,'$'
roland_mess	db	13,10,' *********************** PLAYING ROLAND GODFATHER MUSIC*******************',13,10,13,10,'$'
adlib_mess	db	13,10,' *********************** PLAYING  ADLIB GODFATHER MUSIC ******************',13,10,13,10,'$'
select_tune_mess db	13,10,' 1= MAIN THEME',13,10,'$'

ch1mess		db	'1 ','$'
ch2mess		db	'2 ','$'

;-----------------------------------------------------------------------
;  offsets into midi fx file
fx_table	dw 0
	

;---------------------------------------------------------------
include rolvars.asm
include advars.asm
include nwsongs.asm

dseg	ends
;--------------------------
CStack	segment	para stack 'STACK'		;for stand alone assembly
	db	128 dup(?)
CStack	ends
;--------------------------
cseg	segment	para public 'CODE'
	assume	cs:cseg,ds:dseg
;************************************************************************

	;    TEST CONTROL SECTION to allow stand alone testing
	;   	   can be deleted when not required


Start proc near
	mov	dx,ds
	mov	si,2
	mov	bx,[si]
	mov	ax,dseg
	mov	ds,ax
	cld			;default direction flag

;-------------------------------
board_select:
	;  SELECT WHICH BOARD TO USE

	mov	dx,offset board_mess
	call	print


GBrd:	call	GetKey		;Roland or Adlib?
	cmp	al,'a'	
	jne	checkROL		;Adlib
	jmp	play_ad_board
checkROL:
	cmp	al,'r'
	jne	GBrd		;CHANGED

	;    PLAY SONG ON ROLAND

	mov	BoardFlg,0
	jmp	choose_mode
play_ad_board:
	mov	boardFlg,1
	mov	mode_flag,0	;music only on adlib
	;mov	song_number,1
	call	far ptr load_files
	mov	dx,offset adlib_mess
	call print
	jmp	adj1
;---------------------------------

	;  CHOOSE MUSIC OR FX ON  ROLAND

;   test wait for key loop
choose_mode:
	;-----------------------------
	;   first load the correct file
	;mov	song_number,1	; default tune
	mov	dx,offset load_mess
	call print
	call far ptr load_files	; get em in
	;-----------------------------
	;mov	dx,offset mode_mess
	;call print
	;call   getkey
			;choose music or fx
	;cmp	al,'m'	;  m = music
	;jne	check_fx
	mov	dx,offset roland_mess
	call print

adj1:	mov	mode_flag,0	;  music mode
	;mov	dx,offset select_tune_mess
	;call print
	;call   getkey
	;sub 	al,48		;  tune number
	mov al,1		; only one tune
	mov [song_number],al
	call	far ptr do_music
	jmp test_loop
check_fx:

set_fx_mode:

;--------------------------------------------
;       TEST LOOP......IE SITS IN THIS LOOP WHILE RUNNING MIDI
	;  interrupts play music
test_loop:
	mov	dx,offset fin_mess
	call print
	
test_loop1:			; TEST FOR KEY PRESS TO FINISH
	call	CheckKey
	jz	test_loop1
	call	GetKey
	cmp	al,'1'		;  quit altogether
	je	back_to_dos
	cmp	al,'2'		;   reset to choose mode
	je	reset

;    must be key to trigger fx
	jmp 	test_loop1

;------------------------

back_to_dos:

	call far ptr terminate
	mov	ah,4ch
	int 21h
	ret
reset:
	call far ptr terminate
	jmp start
start	endp
;---------------------------------
print	proc near
		;  input  dx	points to message

	push	ax
	mov	ah,9
	int 21h
	pop 	ax
	ret
	
print	endp

;		END OF CONTROL TEST (deletable) SECTION
;************************************************************************
;************************************************************************
;************************************************************************
;************************************************************************

	;  		ACTUAL DRIVER ROUTINES

	;    	call here to start music
	;	boardflg must be set 0= ROLAND 1 = ADLIB 


;----------------------------------------------
;;;;;;;DO MUSIC ROUTINE

do_music  proc far

	mov	dx,ds
	mov	si,2
	mov	bx,[si]
	mov	ax,dseg
	mov	ds,ax
	cld	

	mov	[tickspq],96
	mov	al,[song_number]
	xor 	ah,ah
	cmp	boardFlg,0
	jne	playad
	call	makesound
	ret 
playad:
	cmp	ax,1
	jne	nocorr
	;dec	ax	;song 0
nocorr:	call	playsad
	ret
do_music endp 
;*************************************
load_files proc far
			;  call here to load required MIDI files
			;  The files must be in the current directory
			;  and the boardflg must be set

	mov	dx,ds
	mov	si,2
	mov	bx,[si]
	mov	ax,dseg
	mov	ds,ax
	cld			;default direction flag
	call	LOAD_MIDI_FILES
	ret

load_files endp
;************************************
terminate proc far

			;  call here to stop sound on both boards
			;  boardflg must be set.

	mov	dx,ds
	mov	si,2
	mov	bx,[si]
	mov	ax,dseg
	mov	ds,ax
	cld			;default direction flag
	cmp boardflg,0
	jne	stop_ad
	mov	ch1_flag,0
	mov	ch2_flag,0	;clear fx flags
	call rcc10
	call rcc2
	call ano2
	call ano10

	call stopMusicR
	ret
stop_ad:
	call stopmidiplayadlib
	ret
terminate endp
;-------------------------------------------------------
fx_mode_on proc far
	;   play fx
	;   SEt UP THE TIMER AND FLAGS TO RUN THE FX DRIVER
	;   UNDER A 50 HZ INTERRUPT

	;   board to reset status
	ret

fx_mode_on endp	 
;*************************************************
trigger_fx proc far
	ret

trigger_fx endp

;------------------------------------------------
	; controller subroutines
rcc2:			;reset cont. ch2
	mov	al,0B1h
	call 	TXLAData
	mov	al,79h
	call	TXLAData
	mov	al,0
	call	TXLAData
	ret

ano2:	;  all notes off two
	mov	al,0B1h		;all notes off ch2
	call	TxLAData
	mov	al,07Bh	
	call	TxLAData
	ret

rcc10:				;reset all controllers
	mov	al,0B9h
	call 	TXLAData
	mov	al,79h
	call	TXLAData
	mov	al,0
	call	TXLAData
	ret


ano10:	;  all notes off 10
	mov	al,0B9h		;all notes off ch10
	call	TxLAData
	mov	al,07Bh	
	call	TxLAData

	mov	al,0
	call	Txladata


	ret




resetall:
	ret
;*************************************************

;   THIS ROUTINE IS CALLED BY THE TIMER INTERRUPT WHEN PLAYING ROLAND FX.


rol_fx_driver proc near

	cmp	int_flag,1	;fx being set up/miss one
	je	fin_fx_call	
	
	mov	ax,fx_segment
	mov	es,ax

;- - - - - - - - - - - - - - - - - - - - 
;    THIS SECTION IS CHANNEL SPECIFIC
	; test for fx playing on channel 1
	
	cmp	ch1_flag,0
	je	ch2		; should go next chann
			;   channel 1 playing

	mov	run1,1			;which channel flag
	mov	si,ch1_pattp
	cmp	ch1_intc,0
	jne	ch1_wait

;                          check for end of current fx
next_event_now1:
	mov	al,es:[si]
	cmp	al,255
	je 	ch1_off
	call	process_data		;next event ready to process
	call	getvarlength
	cmp	ax,0
	je	next_event_now1
	mov	ch1_pattp,si	;store offset
	mov	ch1_intc,ax
ch1_wait:
	mov	ax,ch1_intc
	dec	ax
	mov	ch1_intc,ax
;**********
ch2:	
	; test for fx playing on channel 2
	cmp	ch2_flag,0
	je	fin_fx_call	
			;   channel 2 playing

	mov	run1,0		;which channel 0 =2
	mov	si,ch2_pattp
	cmp	ch2_intc,0
	jne	ch2_wait
;                          check for end of current fx
next_event_now2:
	mov	al,es:[si]
	cmp	al,255
	je 	ch2_off
	call	process_data		;next event ready to process
	call	getvarlength
	cmp	ax,0
	je	next_event_now2
	mov	ch2_pattp,si	;store offset
	mov	ch2_intc,ax
ch2_wait:
	mov	ax,ch2_intc
	dec	ax
	mov	ch2_intc,ax

;**********
fin_fx_call:
	mov	ax,1	;  next delay 
	ret
;--------------------------------------------
ch1_off:
	call	rcc10
	mov	ch1_flag,0
	jmp	ch2
ch2_off:
	call	rcc2
	mov	ch2_flag,0
	jmp	fin_fx_call
;****************************************
process_data:
	call	send_next_event
	ret
;----------------------------------
send_next_event:
	mov 	al,es:[si]
	test	al,128	
	jz	old_status

	cmp	run1,0
	jne	running1
	mov	csb2,al	;store status+channel for 2
	jmp running2
running1:
	mov	csb1,al	;store status+channel for 1
running2:
	xor 	ah,ah	
	mov	 bl,al
	xor	bh,bh
	mov	cl,4
	shr	bx,cl
	mov	cl,MIDIDataSizes[bx]	;value -1
	inc	cl
	xor 	ch,ch
	mov 	MIDIDataSiz,cx
	cmp 	cx,0
	je	event_fin
	cmp	run1,0
	jne	save_len1
	mov	cel2,cx	;store event  len
	jmp	output_event
save_len1:
	mov	cel1,cx	;store event  len
	jmp	output_event	;new 
;-------------------------------------
old_status:
	cmp	run1,0
	jne	get1
	mov	al,csb2
	mov	cx,cel2
	jmp	old_event_entry
get1:
	mov	al,csb1
	mov	cx,cel1
	jmp	old_event_entry
;------------------------------------
output_event:
	mov 	al,es:[si]	;status from file
	inc 	si
old_event_entry:
	call TxLAData
	loop	output_event
event_fin:
	ret

rol_fx_driver endp
;***************************************************	
StopMusicR:
	call	StopMIDIPlayLAPC1
	ret
;play song on AdLib
PlaySAd:
	mov	[song_number],al
	call	PlaySongAdLib
	ret
;------------------------------Start endp

GetKey proc near
	mov	ah,0	;do DOS getkey
	int	16h	;ASCII in al
	ret
GetKey 	endp

CheckKey proc near
	mov	ah,1	;do DOS checkkey
	int	16h
	ret
CheckKey endp

;--------------------------------------------------------------------------------
;LoadSegFile
;
;loads a file into a specified segment
;
;inputs:
;
;ax:	load segment
;dx:	pointer to filename
;di:	load offset
;
;--------------------------------------------------------------------------------

LoadSegFile proc near
	push	ax
	mov	al,0
	mov	ah,3Dh			;open file
	int	21h
	jc	LSFError
	pop	ds
	jmp	LFOpen
LSFError:
	pop	ax
	ret
LoadSegFile endp

LoadFile proc near
	mov	al,0
	mov	ah,3Dh
	int	21h			;open file
	jnc	LFOpen
	jmp	LFError
LFOpen:
	mov	bx,ax
	mov	cx,0
	mov	dx,0
	mov	ax,4202h
	int	21h
	push	ax 		;find size
	mov	cx,0
	mov	dx,0
	mov	ax,4200h
	int	21h
	pop	cx

	push	cx
	mov	dx,di		;buffer
	push	di
	mov	ah,3Fh
	int	21h
	mov	ah,3Eh
	int	21h   		;close
	pop	di
	pop	bx
LFSafe:
	mov	ax,0
	ret
LFError:
	mov	ax,-1
	ret

LoadFile endp

;-----------------------------------------------------------------------------
include roland.asm
;-----------------------------------------------------------------------------
include adlib.asm
;-----------------------------------------------------------------------------
include adtimer.asm
;-----------------------------------------------------------------------------

EndCode:

cseg	ends

	end Start
