;------------------------------------------------------------------------------
;


BoardFlg	db 0	;0 roland 1 for adlib
mode_flag	db 0	;0 for music.. 1 for fx
song_number	db 1	; only one piece of music
;------------------------------------------------------------------------------
; Roland LAPC-1 macros
;------------------------------------------------------------------------------

SnCmd	MACRO b
	mov	al,b
	call	TxLACom		;send a command to LAPC-1
	ENDM

SnDta	MACRO b
	mov	al,b
	call	TxLAData	;send data to LAPC-1
	ENDM

RxDta	MACRO 
	mov	dx,LADataPort	;receive data from LAPC-1
	in	al,dx
	ENDM

SnLA	MACRO p
	mov	si,offset p
	call	SendLAPCChange	;write sys-ex MIDI string to LAPC-1
	ENDM

;------------------------------------------------------------------------------
;hardware definitions
;------------------------------------------------------------------------------

LADataPort	equ 330h
LAComPort	equ 331h
LAStatPort	equ 331h
LADSR		equ 80h
LADRR		equ 40h

;------------------------------------------------------------------------------


LAIntAddr	dw 0
LAIntSeg	dw 0

LAPCNoInts	dw 0

MIDIStatus	db 0	;running status
MIDIChannel	db 0	;channel

MIDIChanCount	dw 16 dup (0)

MIDIDataSiz	dw 0
MIDIDataSizes	db 0	;0	look up table
		db 0	;1
		db 0	;2
		db 0	;3
		db 0	;4
		db 0	;5
		db 0	;6
		db 0	;7
		db 2	;8	;note off
		db 2	;9	;note on
		db 2	;A	;note after touch
		db 2	;B	;control change
		db 1	;C	;program change
		db 1	;D	;channel after touch
		db 2	;E	;pitch wheel
		db 0	;F	;sys ex

;------------------------------------------------------------------------------
;some patches etc.
;------------------------------------------------------------------------------

LAABass	equ 1	;group 1
LAEBass	equ 4	;gr 1
LAStr1	equ 48	;gr 0
LAStr2	equ 49	;gr 0
LAStr3	equ 50	;gr 0
LAVio2	equ 53	;gr 0
LAPiano	equ 1	;gr 0
LAElPi	equ 3	;gr 0
LAHkTk	equ 7	;gr 0
LAChor	equ 34	;gr 0
LAAtmos	equ 37	;gr 0
LAIcRn	equ 41	;gr 0
LAGtr	equ 59	;gr 0
LASax	equ 15	;gr 1
LATromb	equ 26	;gr 1
LATuba	equ 30	;gr 1
LABrs1	equ 31	;gr 1
LABrs2	equ 32	;gr 1
LAVibe1	equ 33	;gr 1
LASnBr2	equ 25	;gr 0
LASnBr3	equ 26	;gr 0

Part1		db 03h,00h,00h,0,0,0,50,12,0,1,0,100,0FFh	;set part 1 to 24, 1 octave down,fine tune,bender,assign,reverb
Part2		db 03h,00h,10h,0,0,0,50,12,0,1,0,100,0FFh
Part3		db 03h,00h,20h,0,0,0,50,12,0,1,0,100,0FFh
Part4		db 03h,00h,30h,0,0,0,50,12,0,1,0,100,0FFh
Part5		db 03h,00h,40h,0,0,0,50,12,0,1,0,100,0FFh
Part6		db 03h,00h,50h,0,0,0,50,12,0,1,0,100,0FFh
Part7		db 03h,00h,60h,0,0,0,50,12,0,1,0,100,0FFh
Part8		db 03h,00h,70h,0,0,0,50,12,0,1,0,100,0FFh
SetVol		db 10h,00h,16h,100,0FFh		;set card to max vol.
SetUpLAMIDI	db 14,16,16,16,1,2,3,4,5,6,7,0FFh	;set up MIDI channels 0-7

MusicPlayFlg	db 0

RecordFlg	db 0
DonePlay	db 0

MIDIBuffer	db 16 dup (0)
MIDIInBytes	dw 0

TimeOver	dw 0

PlaySeg		dw 0
PlayPtr		dw RecBuffer
PlayLength	dw 0
StartPtr	dw 0

RecBufSiz equ 16
RecBuffer	db RecBufSiz dup (0)
RecPtr		dw RecBuffer

;     GLOBAL FX VARIABLES
fx_number	db 0
Tempo		dw 0	;in beats per min
fx_flag		db 0	;interrupt to use fx driver
int_flag	db 0	;disable interrupt routine
csb1		db 0	;current status byte
cel1		dw 0	;current event length
csb2		db 0	;current status byte
cel2		dw 0	;current event length
run1		db 0	;which channel currently running


;   CHANNEL 1 FX VARS
ch1_flag	db 0	;1 = channel playing fx
ch1_pattp	dw 0	;offset pattern pointer for si/ch1
ch1_intc	dw 0	;count in 1/50ths

;   CHANNEL 2 FX VARS
ch2_flag	db 0	;1 = channel playing fx
ch2_pattp	dw 0	;offset pattern pointer for si/ch1
ch2_intc	dw 0	;count in 1/50ths

