/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.lexandparse.Lexer;
import cml.kickass.lexandparse.parser;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.MemoryBlock;
import cml.kickass.state.EvaluationState;
import cml.tools.FileTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblerToolbox {
    public static AsmNode loadAndLex(String filename, EvaluationState state, DebugInfo parrentDebug) throws AsmException {
        InputStream in = state.openFile(filename, parrentDebug);
        return AssemblerToolbox.loadAndLex(in, filename, state, parrentDebug);
    }

    public static AsmNode loadAndLex(File inputFile, EvaluationState state, DebugInfo parrentDebug) throws AsmException {
        String filenameForDebug = FileTool.getCanonicalFilePath(inputFile);
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(inputFile);
        }
        catch (Exception ex) {
            throw new AsmError("Can't create inputstream from file " + FileTool.getCanonicalFilePath(inputFile), parrentDebug);
        }
        return AssemblerToolbox.loadAndLex(istream, filenameForDebug, state, parrentDebug);
    }

    public static AsmNode loadAndLex(InputStream inputfile, String fileNameForDebug, EvaluationState state, DebugInfo parrentDebug) throws AsmException {
        Lexer lexer = new Lexer(inputfile);
        lexer.setInputfilenameForDebugging(fileNameForDebug);
        lexer.setParrentDebugInfo(parrentDebug);
        parser parser2 = new parser(lexer);
        AsmNodeList root = null;
        try {
            List list = (List)parser2.parse().value;
            root = new AsmNodeList(list);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AsmError(ex.getMessage(), null);
        }
        return root;
    }

    public static String printMemoryBlocks(List<MemoryBlock> globalMemoryBlocks) {
        ArrayList<MemoryBlock> memoryBlocks = new ArrayList<MemoryBlock>();
        memoryBlocks.addAll(globalMemoryBlocks);
        Comparator<MemoryBlock> comp = new Comparator<MemoryBlock>(){

            @Override
            public int compare(MemoryBlock mb1, MemoryBlock mb2) {
                int a2;
                int a1 = mb1.getStartAdress();
                if (a1 < (a2 = mb2.getStartAdress())) {
                    return -1;
                }
                if (a1 == a2) {
                    return 0;
                }
                return 1;
            }
        };
        Collections.sort(memoryBlocks, comp);
        String result = "Memory Map\n----------\n";
        for (MemoryBlock mb : memoryBlocks) {
            int start = mb.getStartAdress();
            int end = mb.getStartAdress() + mb.getSize() - 1;
            String virtualPrefix = mb.isVirtual() ? "*" : "";
            result = String.valueOf(result) + virtualPrefix + AssemblerToolbox.intToHexString(start) + "-" + AssemblerToolbox.intToHexString(end) + " " + mb.getName() + "\n";
        }
        return result;
    }

    private static String intToHexString(int x) {
        String hexString = Integer.toHexString(x);
        int extraZeros = Math.max(4 - hexString.length(), 0);
        int i = 0;
        while (i < extraZeros) {
            hexString = "0" + hexString;
            ++i;
        }
        return "$" + hexString;
    }
}

