/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass;

import cml.kickass.AssemblerToolbox;
import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.asmnode.output.reciever.MainOutputReciever;
import cml.kickass.exceptions.AsmError;
import cml.kickass.libraries.MathLibrary;
import cml.kickass.libraries.MiscLibrary;
import cml.kickass.libraries.MnemonicsLibrary;
import cml.kickass.libraries.PrintLibrary;
import cml.kickass.libraries.StdConstructorLibrary;
import cml.kickass.libraries.VectorLibrary;
import cml.kickass.misc.C64File;
import cml.kickass.misc.ViceSymbolFile;
import cml.kickass.state.AssertManager;
import cml.kickass.state.EvaluationState;
import cml.log.Log;
import cml.tools.FileTool;
import cml.tools.Timer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class KickAssembler {
    private static final String AUTO_INCLUDED_FILE = "/include/autoinclude.asm";
    private static Log log = new Log("");

    public static void main(String[] args) {
        log.addPrintStream(System.out);
        log.println("//------------------------------------------------------");
        log.println("//------------------------------------------------------");
        log.println("//   Kick Assembler v3.2 - (C)2006-2009 Mads Nielsen    ");
        log.println("//------------------------------------------------------");
        log.println("//------------------------------------------------------");
        File currentDir = new File(".");
        String outputfile = null;
        ArrayList<File> libPath = new ArrayList<File>();
        libPath.add(currentDir);
        String inputFileName = null;
        boolean showMemoryMap = false;
        boolean debug = false;
        String executeOnSuccess = null;
        boolean dtvMode = false;
        boolean allowOverlappingMemoryblocks = false;
        boolean warnings = true;
        boolean time = false;
        boolean viceSymbols = false;
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).equalsIgnoreCase("-o")) {
                KickAssembler.ensureArgument(i, args, "-o");
                outputfile = args[i++];
                continue;
            }
            if (arg.equalsIgnoreCase("-libdir")) {
                KickAssembler.ensureArgument(i, args, "-libdir");
                libPath.add(new File(args[i++]));
                continue;
            }
            if (arg.equalsIgnoreCase("-execute")) {
                KickAssembler.ensureArgument(i, args, "-execute");
                executeOnSuccess = args[i++];
                continue;
            }
            if (arg.equalsIgnoreCase("-showmem")) {
                showMemoryMap = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-debug")) {
                debug = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-dtv")) {
                dtvMode = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-time")) {
                time = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-warningsoff")) {
                warnings = false;
                continue;
            }
            if (arg.equalsIgnoreCase("-aom")) {
                allowOverlappingMemoryblocks = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-vicesymbols")) {
                viceSymbols = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-log")) {
                KickAssembler.ensureArgument(i, args, "-log");
                try {
                    log.addPrintStream(new PrintStream(new FileOutputStream(args[i++])));
                }
                catch (Exception ex) {
                    log.println("Couldn't create log : " + ex.getMessage());
                }
                continue;
            }
            if (inputFileName == null) {
                inputFileName = arg;
                continue;
            }
            log.println("Warning. Allready have an inputfile. Won't use '" + arg + "'");
        }
        Log.setDebugging(debug);
        Log.setWarnings(warnings);
        C64File.allowOverlappingMemoryBlocks(allowOverlappingMemoryblocks);
        if (inputFileName == null) {
            log.println("Error: No inputfile supplied.");
            return;
        }
        if (!new File(inputFileName).exists()) {
            log.println("Error: Inputfile '" + inputFileName + "' doesn't exist.");
            return;
        }
        String inputfileWithoutExt = inputFileName;
        int idx = inputfileWithoutExt.lastIndexOf(46);
        if (idx >= 0) {
            inputfileWithoutExt = inputfileWithoutExt.substring(0, idx);
        }
        if (outputfile == null) {
            outputfile = String.valueOf(inputfileWithoutExt) + ".prg";
        }
        EvaluationState state = new EvaluationState();
        try {
            AssertManager am;
            long startTime = System.nanoTime();
            state.setSourceLibraryPath(libPath);
            state.setDtvMode(dtvMode);
            state.addLibrary(new MathLibrary());
            state.addLibrary(new PrintLibrary());
            state.addLibrary(new VectorLibrary());
            state.addLibrary(new StdConstructorLibrary());
            state.addLibrary(new MiscLibrary());
            state.addLibrary(new MnemonicsLibrary());
            log.println("parsing");
            AsmNodeList startNode = new AsmNodeList();
            InputStream autoIncludeStream = new KickAssembler().getClass().getResourceAsStream(AUTO_INCLUDED_FILE);
            startNode.add(AssemblerToolbox.loadAndLex(autoIncludeStream, AUTO_INCLUDED_FILE, state, null));
            File inputFile = state.getFile(inputFileName, null);
            state.setCurrentDirectory(FileTool.getCanonicalDirectory(inputFile));
            startNode.add(AssemblerToolbox.loadAndLex(inputFileName, state, null));
            AsmNode asmTree = startNode;
            do {
                state.prepareNewParse();
                log.println("flex pass " + state.getPassNo());
                if (state.getPassNo() == 1) {
                    asmTree.preParse(state);
                }
                asmTree = asmTree.parse(state);
                if (state.getMadeMetaProgress() || asmTree.isFinished()) continue;
                state.prepareNewParse();
                state.setFailOnInvalidValue(true);
                asmTree = asmTree.parse(state);
                throw new AsmError("Made no progress and cant solve the program.. You should have gotten an error. Contact the author!", null);
            } while (!asmTree.isFinished());
            log.println("Output pass");
            MainOutputReciever reciever = new MainOutputReciever(8192);
            asmTree.deliverOutput(reciever);
            long assembleTime = System.nanoTime() - startTime;
            if (time) {
                log.println("Assemble time = " + assembleTime / 1000000L + " ms");
            }
            Timer.printTimers();
            if (showMemoryMap) {
                log.println();
                log.println(AssemblerToolbox.printMemoryBlocks(reciever.getMemoryBlocks()));
            }
            if ((am = state.getAssertManager()).getNoOfAsserts() > 0) {
                log.println();
                String failString = am.getNoOfFailedAsserts() == 0 ? " failed" : " FAILED!";
                log.println("Made " + am.getNoOfAsserts() + " asserts , " + am.getNoOfFailedAsserts() + failString);
            }
            C64File file = new C64File(reciever.getMemoryBlocks());
            log.println("Writing file: " + outputfile);
            file.writeFile(outputfile);
            if (viceSymbols) {
                String viceSymbolFile = String.valueOf(inputfileWithoutExt) + ".vs";
                new ViceSymbolFile(state.getCurrentScope()).writeFile(viceSymbolFile);
                log.println("Writing Vice symbol file: " + viceSymbolFile);
            }
            if (executeOnSuccess != null) {
                String cmd = String.valueOf(executeOnSuccess) + " " + outputfile;
                try {
                    Runtime.getRuntime().exec(cmd);
                }
                catch (Exception ex) {
                    log.error("Error while executing external program: " + ex);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof AsmError) {
                ((AsmError)ex).setCallStack(state.getCallStack());
            }
            log.error(ex);
            System.exit(1);
        }
    }

    private static void ensureArgument(int argNr, String[] args, String opt) {
        if (argNr >= args.length) {
            log.println("Missing parameter for '" + opt + "' option");
            System.exit(1);
        }
    }
}

