/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.asmnode.metanodes;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.FunctionSideOutput;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;
import cml.kickass.values.VariableReferenceValue;
import cml.tools.Pair;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentAssignmentNode
extends AsmNode {
    private List<String> names;
    private List<ExprNode> argumentExprs;
    private AsmNode body;
    private DebugInfo debug;
    private Value defaultValue;
    private boolean assingmentOk;
    private Pair<SymbolScopeValue, FunctionSideOutput>[] parameterEvaluationResults;

    public ArgumentAssignmentNode(List<String> names, List<ExprNode> argumentExprs, AsmNode body, Value defaultValue, DebugInfo debug) {
        this.names = names;
        this.argumentExprs = argumentExprs;
        this.body = body;
        this.defaultValue = defaultValue;
        this.debug = debug;
        this.parameterEvaluationResults = new Pair[names.size()];
    }

    @Override
    public AsmNode copy() {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public void deliverOutput(OutputReciever reciever) {
        this.body.deliverOutput(reciever);
    }

    @Override
    public void functionParse(EvaluationState state) {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public boolean isFinished() {
        return this.assingmentOk && this.body.isFinished();
    }

    @Override
    public AsmNode preParse(EvaluationState state) {
        this.body = this.body.preParse(state);
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState state) {
        SymbolScope symbolScope = state.getCurrentScope().getSymbols();
        boolean assignmentOk = true;
        int i = 0;
        while (i < this.names.size()) {
            SymbolScopeValue refValue;
            String name = this.names.get(i);
            Pair<SymbolScopeValue, FunctionSideOutput> paramEvalResult = this.parameterEvaluationResults[i];
            if (paramEvalResult != null) {
                this.parseSideOutput(paramEvalResult.getB(), state);
                refValue = paramEvalResult.getA();
            } else {
                boolean evalOk;
                state.clearFunctionSideOutput();
                Value value = this.argumentExprs.size() <= i ? this.defaultValue : this.argumentExprs.get(i).evaluate(state);
                refValue = new VariableReferenceValue(value);
                boolean bl = evalOk = !state.getErrrorDuringFunctionEvaluation();
                if (evalOk && value.isLocked() && !value.hasInvalidContent()) {
                    this.parameterEvaluationResults[i] = new Pair<SymbolScopeValue, FunctionSideOutput>(refValue, state.getFunctionSideOutput());
                }
                assignmentOk &= evalOk;
            }
            symbolScope.put(name, refValue);
            ++i;
        }
        this.assingmentOk = assignmentOk;
        this.body = this.body.parse(state);
        return this;
    }
}

