/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.asmnode.metanodes;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.state.EvaluationState;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmNodeList
extends AsmNode {
    private boolean isFinished = false;
    private List<AsmNode> list;

    public AsmNodeList() {
        this.list = new ArrayList<AsmNode>();
    }

    public AsmNodeList(List<AsmNode> list) {
        this.list = list;
    }

    public List<AsmNode> getValues() {
        return this.list;
    }

    public void add(AsmNode node) {
        this.list.add(node);
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public AsmNode parse(EvaluationState state) {
        boolean finished = true;
        int size = this.list.size();
        int i = 0;
        while (i < size) {
            AsmNode newNode = this.list.get(i).parse(state);
            this.list.set(i, newNode);
            finished = finished && newNode.isFinished();
            ++i;
        }
        this.isFinished = finished;
        return this;
    }

    @Override
    public AsmNode preParse(EvaluationState state) {
        boolean finished = true;
        int i = 0;
        while (i < this.list.size()) {
            AsmNode newNode = this.list.get(i).preParse(state);
            this.list.set(i, newNode);
            finished = finished && newNode.isFinished();
            ++i;
        }
        this.isFinished = finished;
        return this;
    }

    @Override
    public AsmNode copy() {
        ArrayList<AsmNode> newList = new ArrayList<AsmNode>();
        newList.ensureCapacity(this.list.size());
        for (AsmNode node : this.list) {
            newList.add(node.copy());
        }
        return new AsmNodeList(newList);
    }

    @Override
    public void deliverOutput(OutputReciever reciever) {
        for (AsmNode node : this.list) {
            node.deliverOutput(reciever);
        }
    }

    public String toString() {
        return "AsmNodeList";
    }

    @Override
    public void functionParse(EvaluationState state) {
        for (AsmNode node : this.list) {
            node.functionParse(state);
        }
    }
}

