/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.asmnode.metanodes;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.state.scope.StdScope;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.NameSpaceValue;

public class ScopeNode
extends AsmNode {
    private AsmNode body;
    private DebugInfo debug;
    private boolean addDebugToCallStack = false;
    private String nameSpaceId;
    private Scope scope;

    public ScopeNode(AsmNode body) {
        this(body, null, false, null);
    }

    public ScopeNode(AsmNode body, String nameSpaceId, boolean addDebugToCallStack, DebugInfo debug) {
        this.body = body;
        this.debug = debug;
        this.nameSpaceId = nameSpaceId;
        this.addDebugToCallStack = addDebugToCallStack;
    }

    public AsmNode copy() {
        throw NotImplementedException.intance;
    }

    public void enterScope(EvaluationState state) {
        if (this.scope == null) {
            this.scope = new StdScope(state.getCurrentScope(), true);
        }
        if (this.addDebugToCallStack) {
            state.getCallStack().push(this.debug);
        }
        state.setCurrentScope(this.scope);
    }

    public void exitScope(EvaluationState state) {
        state.setCurrentScope(this.scope.getParrent());
        if (this.addDebugToCallStack) {
            state.getCallStack().pop();
        }
    }

    public AsmNode preParse(EvaluationState state) {
        Scope outerScope = state.getCurrentScope();
        this.enterScope(state);
        if (this.nameSpaceId != null) {
            SymbolScope outerSymbols = outerScope.getSymbols();
            if (outerSymbols.getLocalDefinedEntities().containsKey(this.nameSpaceId)) {
                throw new AsmError("The symbol is already in use. Can't use '" + this.nameSpaceId + "' as namespace name.", this.debug);
            }
            outerScope.getSymbols().put(this.nameSpaceId, new NameSpaceValue(this.scope, false));
        }
        this.body = this.body.preParse(state);
        this.exitScope(state);
        return this;
    }

    public AsmNode parse(EvaluationState state) {
        this.enterScope(state);
        this.body = this.body.parse(state);
        this.exitScope(state);
        return this;
    }

    public void functionParse(EvaluationState state) {
        throw NotImplementedException.intance;
    }

    public void deliverOutput(OutputReciever reciever) {
        this.body.deliverOutput(reciever);
    }

    public boolean isFinished() {
        return this.body.isFinished();
    }
}

