/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.asmnode.metanodes;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.state.EvaluationState;

public class SetCurrentDirectoryNode
extends AsmNode {
    private String directory;
    private AsmNode body;

    public SetCurrentDirectoryNode(String directory, AsmNode body) {
        this.directory = directory;
        this.body = body;
    }

    public AsmNode copy() {
        return new SetCurrentDirectoryNode(this.directory, this.body);
    }

    public void deliverOutput(OutputReciever reciever) {
        this.body.deliverOutput(reciever);
    }

    public void functionParse(EvaluationState state) {
        throw ShouldNotBeHereException.instance;
    }

    public boolean isFinished() {
        return this.body.isFinished();
    }

    public AsmNode parse(EvaluationState state) {
        String outerCurrentPath = state.getCurrentDirectory();
        state.setCurrentDirectory(this.directory);
        this.body.parse(state);
        state.setCurrentDirectory(outerCurrentPath);
        return this;
    }

    public AsmNode preParse(EvaluationState state) {
        String outerCurrentPath = state.getCurrentDirectory();
        state.setCurrentDirectory(this.directory);
        this.body.preParse(state);
        state.setCurrentDirectory(outerCurrentPath);
        return this;
    }
}

