/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.Directive;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;
import cml.log.Log;

public class AssertDirective
extends Directive {
    Log log = new Log("AssertDirective");
    ExprNode msgExpr;
    ExprNode resultExpr;
    ExprNode expectedExpr;

    public AssertDirective(ExprNode msgExpr, ExprNode resultExpr, ExprNode expectedExpr, DebugInfo debug) {
        super(debug);
        this.msgExpr = msgExpr;
        this.resultExpr = resultExpr;
        this.expectedExpr = expectedExpr;
    }

    public AsmNode parse(EvaluationState state) {
        String errorMsg;
        boolean invalidContent;
        state.clearFunctionSideOutput();
        Value msgValue = this.msgExpr.evaluate(state);
        Value resultValue = this.resultExpr.evaluate(state);
        Value expectedValue = this.expectedExpr.evaluate(state);
        boolean bl = invalidContent = resultValue.hasInvalidContent() || expectedValue.hasInvalidContent();
        if (invalidContent || state.getErrrorDuringFunctionEvaluation()) {
            return this;
        }
        Value[] argList = new Value[]{resultValue.deReference(), expectedValue.deReference()};
        Function equalFunction = resultValue.getFunctions().get("==", argList, this.debug);
        boolean ok = equalFunction.execute(argList, state, this.debug).getBoolean(this.debug);
        String string = errorMsg = ok ? "" : " -- ERROR IN ASSERTION!!!";
        if (state.getErrrorDuringFunctionEvaluation()) {
            return this;
        }
        state.addTextOutput(String.valueOf(msgValue.getString(this.debug)) + "=" + resultValue.getString(this.debug) + " (" + expectedValue.getString(this.debug) + ")" + errorMsg);
        state.getAssertManager().madeAssert(!ok);
        return new SideEffectOnlyOutput(state.getFunctionSideOutput());
    }

    public AsmNode copy() {
        return this;
    }

    public void functionParse(EvaluationState state) {
        throw new AsmError("You cannot use the assert directive in function mode", this.debug);
    }
}

