/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.directives.Directive;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.StdScope;
import cml.kickass.values.Value;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForDirective
extends Directive {
    private List<ExprNode> initExprs;
    private ExprNode conditionExpr;
    private List<ExprNode> iterExprs;
    private AsmNode body;
    private AsmNode outerScopeNode;

    public ForDirective(List<ExprNode> initExprs, ExprNode conditionExpr, List<ExprNode> iterExprs, AsmNode body, DebugInfo debug) {
        super(debug);
        this.initExprs = initExprs;
        this.conditionExpr = conditionExpr;
        this.iterExprs = iterExprs;
        this.body = body;
    }

    @Override
    public boolean isFinished() {
        return this.outerScopeNode == null ? false : this.outerScopeNode.isFinished();
    }

    @Override
    public void deliverOutput(OutputReciever reciever) {
        this.outerScopeNode.deliverOutput(reciever);
    }

    @Override
    public AsmNode copy() {
        return new ForDirective(this.initExprs, this.conditionExpr, this.iterExprs, this.body, this.debug);
    }

    @Override
    public AsmNode parse(EvaluationState state) {
        if (this.outerScopeNode != null) {
            this.outerScopeNode = this.outerScopeNode.parse(state);
            return this;
        }
        AsmNodeList nodeList = new AsmNodeList();
        ScopeNode outerScopeNode2 = new ScopeNode(nodeList);
        this.outerScopeNode = outerScopeNode2;
        outerScopeNode2.enterScope(state);
        state.clearFunctionSideOutput();
        this.evaluateExprs(this.initExprs, state);
        while (this.errorIfInvalid(this.conditionExpr.evaluate(state)).getBoolean(this.debug)) {
            nodeList.add(new SideEffectOnlyOutput(state.getFunctionSideOutput()));
            AsmNode node = new ScopeNode(this.body.copy());
            node = ((AsmNode)node).preParse(state).parse(state);
            nodeList.add(node);
            state.clearFunctionSideOutput();
            this.evaluateExprs(this.iterExprs, state);
        }
        nodeList.add(new SideEffectOnlyOutput(state.getFunctionSideOutput()));
        outerScopeNode2.exitScope(state);
        return this;
    }

    private void evaluateExprs(List<ExprNode> list, EvaluationState state) {
        int i = 0;
        while (i < list.size()) {
            list.get(i).evaluate(state);
            ++i;
        }
    }

    private Value errorIfInvalid(Value value) {
        if (value.isInvalid()) {
            throw new AsmError("Can't evaluate condition in first pass", this.debug);
        }
        return value;
    }

    @Override
    public void functionParse(EvaluationState state) {
        StdScope outerScope = new StdScope(state.getCurrentScope(), false);
        state.setCurrentScope(outerScope);
        this.evaluateExprs(this.initExprs, state);
        try {
            while (this.errorIfInvalid(this.conditionExpr.evaluate(state)).getBoolean(this.debug)) {
                StdScope innerScope = new StdScope(outerScope, false);
                state.setCurrentScope(innerScope);
                this.body.functionParse(state);
                state.setCurrentScope(outerScope);
                this.evaluateExprs(this.iterExprs, state);
            }
        }
        finally {
            state.setCurrentScope(outerScope.getParrent());
        }
    }
}

