/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.Directive;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SideEffect;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.FunctionSideOutput;
import cml.kickass.values.Value;

public class IfDirective
extends Directive {
    private ExprNode conditionExpr;
    private AsmNode trueBody;
    private AsmNode falseBody;
    private boolean conditionDone = false;
    private FunctionSideOutput conditionSideEffects;
    private AsmNode scopeNode;

    public IfDirective(ExprNode conditionExpr, AsmNode trueBody, AsmNode falseBody, DebugInfo debug) {
        super(debug);
        this.conditionExpr = conditionExpr;
        this.trueBody = trueBody;
        this.falseBody = falseBody;
    }

    public AsmNode copy() {
        AsmNode newFalseBody = this.falseBody == null ? null : this.falseBody.copy();
        return new IfDirective(this.conditionExpr, this.trueBody.copy(), newFalseBody, this.debug);
    }

    public AsmNode parse(EvaluationState state) {
        AsmNode selectedBody = null;
        if (this.conditionDone) {
            this.execSideEffects(this.conditionSideEffects, state);
        } else {
            state.clearFunctionSideOutput();
            Value conditionValue = this.conditionExpr.evaluate(state);
            if (conditionValue.isInvalid()) {
                throw new AsmError("The condition must be able to evaluate i first parse", this.debug);
            }
            AsmNode asmNode = selectedBody = conditionValue.getBoolean(this.debug) ? this.trueBody : this.falseBody;
            if (!state.getErrrorDuringFunctionEvaluation()) {
                this.conditionDone = true;
                this.conditionSideEffects = state.getFunctionSideOutput();
            }
        }
        if (this.scopeNode == null) {
            this.scopeNode = selectedBody == null ? EmptyOutput.instance : new ScopeNode(selectedBody);
            this.scopeNode = this.scopeNode.preParse(state);
        }
        this.scopeNode = this.scopeNode.parse(state);
        if (this.conditionDone && this.conditionSideEffects == null) {
            return this.scopeNode;
        }
        return this;
    }

    private void execSideEffects(FunctionSideOutput sideOutput, EvaluationState state) {
        if (sideOutput != null) {
            for (SideEffect sideEffect : sideOutput.getSideEffects()) {
                sideEffect.evaluate(state, this.debug);
            }
        }
    }

    public void functionParse(EvaluationState state) {
        Value conditionValue = this.conditionExpr.evaluate(state);
        if (conditionValue.isInvalid()) {
            throw new AsmError("Invalid/Unresolved condition value. Can't resolve if", this.debug);
        }
        boolean condition = conditionValue.getBoolean(this.debug);
        if (condition) {
            this.trueBody.functionParse(state);
        } else if (this.falseBody != null) {
            this.falseBody.functionParse(state);
        }
    }

    public boolean isFinished() {
        return this.scopeNode != null && this.scopeNode.isFinished();
    }
}

