/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.Directive;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class PrintDirective
extends Directive {
    private ExprNode msgExpr;

    public PrintDirective(ExprNode msgExpr, DebugInfo debug) {
        super(debug);
        this.msgExpr = msgExpr;
    }

    public AsmNode copy() {
        return this;
    }

    public AsmNode parse(EvaluationState state) {
        state.clearFunctionSideOutput();
        Value msgValue = this.msgExpr.evaluate(state);
        if (state.getErrrorDuringFunctionEvaluation()) {
            return this;
        }
        String text = msgValue.getString(this.debug);
        state.addTextOutput(text);
        return new SideEffectOnlyOutput(state.getFunctionSideOutput());
    }

    public void functionParse(EvaluationState state) {
        Value msgValue = this.msgExpr.evaluate(state);
        if (msgValue.isInvalid()) {
            return;
        }
        String text = msgValue.getString(this.debug);
        state.addTextOutput(text);
    }
}

