/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.directives.Directive;
import cml.kickass.directives.asmmode.LabelDirective;
import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.StdScope;

public class ScopeDirective
extends Directive {
    private AsmNode body;
    private String nameSpaceId;

    public ScopeDirective(AsmNode body) {
        this(body, null);
    }

    public ScopeDirective(AsmNode body, String nameSpaceId) {
        super(null);
        this.body = body;
        this.nameSpaceId = nameSpaceId;
    }

    public boolean connectToLabel(LabelDirective label) {
        if (this.nameSpaceId != null) {
            return false;
        }
        this.nameSpaceId = label.getName();
        label.setDontInsertLabelInScope(true);
        return true;
    }

    public AsmNode preParse(EvaluationState state) {
        return new ScopeNode(this.body, this.nameSpaceId, false, this.debug).preParse(state);
    }

    public AsmNode parse(EvaluationState state) {
        throw NotImplementedException.intance;
    }

    public AsmNode copy() {
        return this;
    }

    public void functionParse(EvaluationState state) {
        StdScope scope = new StdScope(state.getCurrentScope(), false);
        state.setCurrentScope(scope);
        this.body.functionParse(state);
        state.setCurrentScope(scope.getParrent());
    }
}

