/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class AlignDirective
extends AsmDirective {
    private ExprNode argExpr;

    public AlignDirective(ExprNode argExpr, DebugInfo debug) {
        super(debug);
        this.argExpr = argExpr;
    }

    public AsmNode copy() {
        return this;
    }

    public AsmNode parse(EvaluationState state) {
        state.clearFunctionSideOutput();
        Value alignValue = this.argExpr.evaluate(state);
        if (alignValue.isInvalid()) {
            return this.invalidatePcAndReturnThis(state);
        }
        int n = alignValue.getInt(this.debug);
        if (n <= 0) {
            throw new AsmError("Alignment size must be positive.", this.debug);
        }
        Integer pc = state.getMemoryPosition();
        if (pc == null) {
            return this.invalidatePcAndReturnThis(state);
        }
        int adjustment = n - pc % n;
        if (adjustment == n) {
            adjustment = 0;
        }
        state.increaseMemoryPosition(adjustment);
        if (state.getErrrorDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(new byte[adjustment], state.getFunctionSideOutput());
    }
}

