/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.ArgTypes;
import cml.kickass.misc.Argument;
import cml.kickass.misc.MnemonicTable;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class AsmCommand
extends AsmDirective {
    private String mnemonic;
    private ExprNode argumentExpr;
    private CmdClass cmdClass;
    private int resolvedType;

    public AsmCommand(String mnemonic, ExprNode argumentExpr, CmdClass cmdClass, DebugInfo debugInfo) {
        this(mnemonic, argumentExpr, cmdClass, -1, debugInfo);
    }

    public AsmCommand(String mnemonic, ExprNode argumentExpr, CmdClass cmdClass, int resolvedType, DebugInfo debugInfo) {
        super(debugInfo);
        this.argumentExpr = argumentExpr;
        this.mnemonic = mnemonic;
        this.cmdClass = cmdClass;
        this.resolvedType = resolvedType;
    }

    public AsmNode copy() {
        return this;
    }

    public AsmNode parse(EvaluationState state) {
        state.clearFunctionSideOutput();
        if (this.cmdClass == CmdClass.DTV && !state.getDtvMode()) {
            throw new AsmError("You are using a dtv command without being in dtv mode. Use -dtv to turn on dtv mode", this.debug);
        }
        Value argValue = this.argumentExpr.evaluate(state);
        Argument argument = argValue.getCmdArgument(this.debug);
        Value intValue = argument.getValue();
        Integer argInt = intValue.isInvalid() || argument.getType() == 0 ? null : Integer.valueOf(intValue.getInt(this.debug));
        int[] modes = MnemonicTable.getPossibleModes(this.mnemonic);
        int type = this.resolvedType;
        if (type < 0) {
            type = this.resolveArgType(argument.getType(), argInt, modes);
        }
        int cmdSize = 1 + ArgTypes.getSize(type);
        state.increaseMemoryPosition(cmdSize);
        int opcode = modes[type];
        if (opcode == -1) {
            String argType = ArgTypes.typeToString(argument.getType());
            throw new AsmError("invalid adressingmode. '" + this.mnemonic + "' doesn't support " + argType + " mode", this.debug);
        }
        if (intValue.isInvalid()) {
            return this.cmdWithResolvedType(type);
        }
        if (type == 11) {
            Integer pc = state.getMemoryPosition();
            if (pc == null) {
                return this.cmdWithResolvedType(type);
            }
            if ((argInt = Integer.valueOf(argInt - pc)) < -128 || 127 < argInt) {
                throw new AsmError("ERROR - relative address is illegal (the jump distance i to far!)", this.debug);
            }
        }
        byte[] cmdBytes = new byte[cmdSize];
        cmdBytes[0] = (byte)opcode;
        int i = 1;
        while (i < cmdSize) {
            cmdBytes[i] = (byte)(argInt & 0xFF);
            argInt = argInt >> 8;
            ++i;
        }
        if (state.getErrrorDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(cmdBytes, state.getFunctionSideOutput());
    }

    private int resolveArgType(int startType, Integer value, int[] modes) {
        boolean hasRelativeForm;
        int zeropageMode = this.getZeropageMode(startType, modes);
        if (zeropageMode >= 0 && value != null && value <= 255) {
            return zeropageMode;
        }
        boolean bl = hasRelativeForm = modes[11] >= 0;
        if (hasRelativeForm) {
            return 11;
        }
        return startType;
    }

    private int getZeropageMode(int startType, int[] modes) {
        if (startType == 7 && modes[2] >= 0) {
            return 2;
        }
        if (startType == 8 && modes[3] >= 0) {
            return 3;
        }
        if (startType == 9 && modes[4] >= 0) {
            return 4;
        }
        return -1;
    }

    private AsmNode cmdWithResolvedType(int type) {
        if (this.resolvedType >= 0) {
            return this;
        }
        return new AsmCommand(this.mnemonic, this.argumentExpr, this.cmdClass, type, this.debug);
    }

    public String toString() {
        return this.mnemonic;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CmdClass {
        NORMAL,
        DTV;

    }
}

