/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.asmnode.output.reciever.CodeCollectorOutputReciever;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.MemoryBlock;
import cml.kickass.misc.StringTool;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;
import cml.log.Log;

public class AssertCodeDirective
extends AsmDirective {
    Log log = new Log("AssertCodeDirective");
    ExprNode msgExpr;
    AsmNode resultNode;
    AsmNode expectedNode;
    DebugInfo debug;

    public AssertCodeDirective(ExprNode msgExpr, AsmNode resultNode, AsmNode expectedNode, DebugInfo debug) {
        super(debug);
        this.msgExpr = msgExpr;
        this.resultNode = new ScopeNode(resultNode);
        this.expectedNode = new ScopeNode(expectedNode);
    }

    public AsmNode copy() {
        return this;
    }

    public AsmNode preParse(EvaluationState state) {
        this.resultNode = this.resultNode.preParse(state);
        this.expectedNode = this.expectedNode.preParse(state);
        return this;
    }

    public AsmNode parse(EvaluationState state) {
        boolean evalFinished;
        Integer memPos = state.getMemoryPosition();
        state.setMemoryPositionWithoutSideEffect(8192);
        this.resultNode = this.resultNode.parse(state);
        state.setMemoryPositionWithoutSideEffect(8192);
        this.expectedNode = this.expectedNode.parse(state);
        state.setMemoryPositionWithoutSideEffect(memPos);
        state.clearFunctionSideOutput();
        Value msgValue = this.msgExpr.evaluate(state);
        boolean errorOnMsgEval = state.getErrrorDuringFunctionEvaluation();
        boolean bl = evalFinished = this.resultNode.isFinished() && this.expectedNode.isFinished() && !errorOnMsgEval;
        if (!evalFinished) {
            return this;
        }
        String testName = msgValue.getString(this.debug);
        CodeCollectorOutputReciever reciever1 = new CodeCollectorOutputReciever(8192);
        CodeCollectorOutputReciever reciever2 = new CodeCollectorOutputReciever(8192);
        this.resultNode.deliverOutput(reciever1);
        this.expectedNode.deliverOutput(reciever2);
        boolean assertOk = reciever1.codeIsEqual(reciever2);
        String str = assertOk ? String.valueOf(testName) + " -- OK. | " + this.codeToString(reciever1) : String.valueOf(testName) + " -- FAILED! | " + this.codeToString(reciever1) + "  -- " + this.codeToString(reciever2);
        state.addTextOutput(str);
        state.getAssertManager().madeAssert(!assertOk);
        return new SideEffectOnlyOutput(state.getFunctionSideOutput());
    }

    private String codeToString(CodeCollectorOutputReciever reciver) {
        StringBuffer sb = new StringBuffer();
        boolean firstBlock = true;
        for (MemoryBlock block : reciver.getMemoryBlocks()) {
            if (firstBlock) {
                firstBlock = false;
            } else {
                sb.append("; ");
            }
            sb.append(StringTool.toHexString(block.getStartAdress(), 4));
            sb.append(":");
            boolean firstByte = true;
            byte[] byArray = block.getMemory();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                if (firstByte) {
                    firstByte = false;
                } else {
                    sb.append(",");
                }
                sb.append(StringTool.toHexString(b, 2));
                ++n2;
            }
        }
        return sb.toString();
    }
}

