/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.values.Value;
import cml.log.Log;

public class AssertErrorCodeDirective
extends AsmDirective {
    Log log = new Log("AssertCodeDirective");
    ExprNode testNameExpr;
    AsmNode body;
    DebugInfo debug;
    boolean preparsed = false;

    public AssertErrorCodeDirective(ExprNode testNameExpr, AsmNode body, DebugInfo debug) {
        super(debug);
        this.testNameExpr = testNameExpr;
        this.body = new ScopeNode(body);
    }

    public AsmNode copy() {
        return new AssertErrorCodeDirective(this.testNameExpr, this.body, this.debug);
    }

    public AsmNode parse(EvaluationState state) {
        Integer savedMemPos = state.getMemoryPosition();
        boolean savedFunctionMode = state.getFunctionsMode();
        Scope savedScope = state.getCurrentScope();
        int savedStackDepth = state.getCallStack().getStackSize();
        state.setMemoryPositionWithoutSideEffect(8192);
        AsmError asmError = null;
        try {
            if (!this.preparsed) {
                this.body = this.body.preParse(state);
                this.preparsed = true;
            }
            this.body = this.body.parse(state);
        }
        catch (AsmError ex) {
            asmError = ex;
        }
        state.setMemoryPositionWithoutSideEffect(savedMemPos);
        state.setFunctionMode(savedFunctionMode);
        state.setCurrentScope(savedScope);
        state.getCallStack().popTilDepth(savedStackDepth);
        state.clearFunctionSideOutput();
        Value testNameValue = this.testNameExpr.evaluate(state);
        if (asmError == null && !this.body.isFinished()) {
            return this;
        }
        String testName = testNameValue.getString(this.debug);
        String str = asmError != null ? String.valueOf(testName) + " -- OK. | " + asmError.getOneLineMessage() : String.valueOf(testName) + " -- FAILED!";
        state.addTextOutput(str);
        state.getAssertManager().madeAssert(asmError == null);
        return new SideEffectOnlyOutput(state.getFunctionSideOutput());
    }
}

