/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.values.Value;
import cml.log.Log;

public class AssertErrorDirective
extends AsmDirective {
    Log log = new Log("AssertCodeDirective");
    ExprNode testNameExpr;
    ExprNode expr;
    DebugInfo debug;
    boolean preparsed = false;

    public AssertErrorDirective(ExprNode testNameExpr, ExprNode expr, DebugInfo debug) {
        super(debug);
        this.testNameExpr = testNameExpr;
        this.expr = expr;
    }

    public AsmNode copy() {
        return new AssertErrorDirective(this.testNameExpr, this.expr, this.debug);
    }

    public AsmNode parse(EvaluationState state) {
        state.clearFunctionSideOutput();
        boolean savedFunctionMode = state.getFunctionsMode();
        Scope savedScope = state.getCurrentScope();
        int savedStackDepth = state.getCallStack().getStackSize();
        AsmError asmError = null;
        try {
            this.expr.evaluate(state);
        }
        catch (AsmError ex) {
            asmError = ex;
        }
        state.getCallStack().popTilDepth(savedStackDepth);
        state.setFunctionMode(savedFunctionMode);
        state.setCurrentScope(savedScope);
        Value testNameValue = this.testNameExpr.evaluate(state);
        boolean errorEval = state.getErrrorDuringFunctionEvaluation();
        if (asmError == null && errorEval) {
            return this;
        }
        String testName = testNameValue.getString(this.debug);
        String str = asmError != null ? String.valueOf(testName) + " -- OK. | " + asmError.getOneLineMessage() : String.valueOf(testName) + " -- ERROR IN ASSERTION!";
        state.addTextOutput(str);
        state.getAssertManager().madeAssert(asmError == null);
        return new SideEffectOnlyOutput(state.getFunctionSideOutput());
    }
}

