/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBlockDirective
extends AsmDirective {
    private int datasize;
    private ArrayList<ExprNode> datalist;

    public DataBlockDirective(int datasize, ArrayList<ExprNode> datalist, DebugInfo debug) {
        super(debug);
        this.datasize = datasize;
        this.datalist = datalist;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState state) {
        state.clearFunctionSideOutput();
        state.increaseMemoryPosition(this.datasize * this.datalist.size());
        byte[] byteOutput = new byte[this.datasize * this.datalist.size()];
        int p = 0;
        for (ExprNode node : this.datalist) {
            Value dataValue = node.evaluate(state);
            if (dataValue.isInvalid()) {
                p += this.datasize;
                continue;
            }
            int data = dataValue.getInt(this.debug);
            int i = 0;
            while (i < this.datasize) {
                byteOutput[p++] = (byte)(data & 0xFF);
                data >>= 8;
                ++i;
            }
        }
        if (state.getErrrorDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(byteOutput, state.getFunctionSideOutput());
    }
}

