/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SESymbolDeclaration;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.state.scope.StdScope;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.ConstantReferenceValue;
import cml.kickass.values.Value;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineDirective
extends AsmDirective {
    private DebugInfo debug;
    private List<String> ids;
    private AsmNode body;

    public DefineDirective(List<String> ids, AsmNode body, DebugInfo debug) {
        super(debug);
        this.body = body;
        this.ids = ids;
    }

    @Override
    public AsmNode copy() {
        return new DefineDirective(this.ids, this.body, this.debug);
    }

    @Override
    public AsmNode parse(EvaluationState state) {
        Scope outerScope = state.getCurrentScope();
        StdScope scope = new StdScope(null, state.getCurrentScope(), false);
        state.setCurrentScope(scope);
        state.clearFunctionSideOutput();
        state.setFunctionMode(true);
        this.body.functionParse(state);
        state.setFunctionMode(false);
        state.setCurrentScope(outerScope);
        SymbolScope outerSymbolScope = outerScope.getSymbols();
        SymbolScope symbolScope = scope.getSymbols();
        for (String id : this.ids) {
            Value value = (Value)symbolScope.getLocalDefinedEntities().get(id);
            if (value == null) {
                throw new AsmError("Define directive doesn't define '" + id + "'", this.debug);
            }
            value = value.deReference();
            value.lock(this.debug);
            ConstantReferenceValue lockedConstValue = new ConstantReferenceValue(value);
            outerSymbolScope.put(id, lockedConstValue);
            state.addSideEffect(new SESymbolDeclaration(id, lockedConstValue, value));
        }
        if (state.getErrrorDuringFunctionEvaluation()) {
            return this;
        }
        return new SideEffectOnlyOutput(state.getFunctionSideOutput());
    }
}

