/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.log.Log;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class EasterEggDirective
extends AsmDirective {
    private static final Log log = new Log("EasterEgg");

    public EasterEggDirective(DebugInfo debug) {
        super(debug);
    }

    public AsmNode copy() {
        return this;
    }

    public AsmNode parse(EvaluationState state) {
        String resourceFile = "/data/easteregg.prg";
        InputStream in = this.getClass().getResourceAsStream(resourceFile);
        if (in == null) {
            throw new AsmError("Can't find the resource " + resourceFile, this.debug);
        }
        try {
            log.println("Congratulations - You found the easter egg!!");
            String outputFilename = "easteregg.prg";
            log.println("Writing " + outputFilename);
            FileOutputStream out = new FileOutputStream(outputFilename);
            this.readDecodeAndWriteFile(in, out);
            in.close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            log.error("Error while writing the easteregg");
            log.error(e);
        }
        return EmptyOutput.instance;
    }

    private void readDecodeAndWriteFile(InputStream in, OutputStream out) throws Exception {
        int c;
        int i = 0;
        while ((c = in.read()) != -1) {
            out.write(c ^ i & 0xFF);
            ++i;
        }
    }
}

