/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.StdScope;
import cml.kickass.values.NullValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;
import cml.kickass.values.VariableReferenceValue;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FillDirective
extends AsmDirective {
    private ArrayList<ExprNode> arguments;

    @Override
    public AsmNode copy() {
        return this;
    }

    public FillDirective(ArrayList<ExprNode> arguments, DebugInfo debug) {
        super(debug);
        this.arguments = arguments;
    }

    @Override
    public AsmNode parse(EvaluationState state) {
        state.clearFunctionSideOutput();
        if (this.arguments.size() != 2) {
            throw new AsmError("Invalid number of arguemnts", this.debug);
        }
        ExprNode sizeExpr = this.arguments.get(0);
        ExprNode valueExpr = this.arguments.get(1);
        Value sizeValue = sizeExpr.evaluate(state);
        if (sizeValue.isInvalid()) {
            throw new AsmError("You must be able to determine the size argument en first pass", this.debug);
        }
        int size = sizeValue.getInt(this.debug);
        if (size < 0) {
            throw new AsmError("The size of a fill directive cant be negative. Size=" + size, this.debug);
        }
        StdScope iterScope = new StdScope(state.getCurrentScope(), true);
        state.setCurrentScope(iterScope);
        VariableReferenceValue iReference = new VariableReferenceValue(NullValue.instance);
        iterScope.getSymbols().put("i", iReference);
        byte[] bytes = new byte[size];
        int i = 0;
        while (i < size) {
            ((SymbolScopeValue)iReference).setWithoutSideEffect(new NumberValue(i));
            Value value = valueExpr.evaluate(state);
            if (!value.isInvalid()) {
                bytes[i] = (byte)(value.getInt(this.debug) & 0xFF);
            }
            ++i;
        }
        state.setCurrentScope(iterScope.getParrent());
        state.increaseMemoryPosition(size);
        boolean error = state.getErrrorDuringFunctionEvaluation();
        return error ? this : new ByteOutput(bytes, state.getFunctionSideOutput());
    }
}

