/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.AssemblerToolbox;
import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.metanodes.AddDebugToCallStackNode;
import cml.kickass.asmnode.metanodes.PreSideEffectsNode;
import cml.kickass.asmnode.metanodes.SetCurrentDirectoryNode;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.directives.Directive;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.CharToPetsciiConverter;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.FunctionSideOutput;
import cml.kickass.values.Value;
import cml.tools.FileTool;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ImportDirective
extends AsmDirective {
    private String type;
    private ExprNode filenameExpr;

    public ImportDirective(String type, ExprNode filenameExpr, DebugInfo debug) {
        super(debug);
        this.type = type;
        this.filenameExpr = filenameExpr;
    }

    public Directive copy() {
        return this;
    }

    public AsmNode preParse(EvaluationState state) {
        state.clearFunctionSideOutput();
        Value filenameValue = this.filenameExpr.evaluate(state);
        if (filenameValue.isInvalid()) {
            throw new AsmError("Must be able to solve filename during first parse", this.debug);
        }
        String filename = filenameValue.getString(this.debug);
        AsmNode result = null;
        if (this.type.equalsIgnoreCase("binary")) {
            result = this.importBinary(state, filename, false);
        } else if (this.type.equalsIgnoreCase("c64")) {
            result = this.importBinary(state, filename, true);
        } else if (this.type.equalsIgnoreCase("source")) {
            result = this.importSource(state, filename);
        } else if (this.type.equalsIgnoreCase("text")) {
            result = this.importText(state, filename);
        } else {
            throw new AsmError("Unknown import type '" + this.type + "'", this.debug);
        }
        return result;
    }

    public AsmNode parse(EvaluationState state) {
        throw NotImplementedException.intance;
    }

    private AsmNode importBinary(EvaluationState state, String filename, boolean c64File) {
        InputStream in = state.openFile(filename, this.debug);
        byte[] importedBytes = new byte[]{};
        try {
            int bytesRead;
            int maxlength = 65536;
            byte[] data = new byte[65536];
            if (c64File) {
                in.read(data, 0, 2);
            }
            if ((bytesRead = in.read(data, 0, 65536)) < 0) {
                bytesRead = 0;
            }
            importedBytes = new byte[bytesRead];
            int i = 0;
            while (i < bytesRead) {
                importedBytes[i] = data[i];
                ++i;
            }
        }
        catch (Exception ex) {
            throw new AsmError("Can't read file: " + filename, this.debug);
        }
        state.increaseMemoryPosition(importedBytes.length);
        return new ByteOutput(importedBytes, state.getFunctionSideOutput());
    }

    private AsmNode importSource(EvaluationState state, String filename) {
        FunctionSideOutput preSideOutput = state.getFunctionSideOutput();
        File file = state.getFile(filename, this.debug);
        AsmNode node = AssemblerToolbox.loadAndLex(file, state, this.debug);
        node = new AddDebugToCallStackNode(this.debug, node);
        String newDir = FileTool.getCanonicalDirectory(file);
        node = new SetCurrentDirectoryNode(newDir, node);
        AsmNode parsedNode = node.preParse(state);
        return preSideOutput == null ? parsedNode : new PreSideEffectsNode(preSideOutput, parsedNode);
    }

    private AsmNode importText(EvaluationState state, String filename) {
        InputStream in = state.openFile(filename, this.debug);
        byte[] importedText = new byte[]{};
        try {
            InputStreamReader reader = new InputStreamReader(in);
            int maxlength = 65536;
            char[] data = new char[65536];
            int bytesRead = reader.read(data, 0, 65536);
            if (bytesRead < 0) {
                bytesRead = 0;
            }
            int validBytes = 0;
            int i = 0;
            while (i < bytesRead) {
                if (CharToPetsciiConverter.convert(data[i]) != null) {
                    ++validBytes;
                }
                ++i;
            }
            importedText = new byte[validBytes];
            int j = 0;
            int i2 = 0;
            while (i2 < bytesRead) {
                Byte b = CharToPetsciiConverter.convert(data[i2]);
                if (b != null) {
                    importedText[j++] = b;
                }
                ++i2;
            }
        }
        catch (Exception ex) {
            throw new AsmError("Can't read file: " + filename, this.debug);
        }
        state.increaseMemoryPosition(importedText.length);
        return new ByteOutput(importedText, state.getFunctionSideOutput());
    }
}

