/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.LabelReferenceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;

public class LabelAssignmentDirective
extends AsmDirective {
    private String name;
    private ExprNode valueExpr;

    public LabelAssignmentDirective(String name, ExprNode valueExpr, DebugInfo debug) {
        super(debug);
        this.name = name;
        this.valueExpr = valueExpr;
    }

    public AsmNode copy() {
        return this;
    }

    public AsmNode parse(EvaluationState state) {
        state.clearFunctionSideOutput();
        Value value = this.valueExpr.evaluate(state);
        if (value.isInvalid()) {
            return this;
        }
        if (!value.hasRepresentation(Value.RP_DOUBLEVALUE)) {
            throw new AsmError("The value of a label. This expression returns a value of type '" + value.getType() + "'", this.debug);
        }
        SymbolScope symbolScope = state.getCurrentScope().getSymbols();
        LabelReferenceValue labelReference = (LabelReferenceValue)symbolScope.getLocalDefinedEntities().get(this.name);
        labelReference.setResolvedLabelValue(value, state, this.debug);
        state.setMadeMetaProgress();
        return new SideEffectOnlyOutput(state.getFunctionSideOutput());
    }

    public AsmNode preParse(EvaluationState state) {
        SymbolScope symbolScope = state.getCurrentScope().getSymbols();
        SymbolScopeValue existingSymbol = (SymbolScopeValue)symbolScope.getLocalDefinedEntities().get(this.name);
        if (existingSymbol != null) {
            throw new AsmError("The symbol '" + this.name + "' is already defined", this.debug);
        }
        symbolScope.put(this.name, new LabelReferenceValue());
        return this;
    }

    public String toString() {
        return "Label(" + this.name + ")";
    }
}

