/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.LabelReferenceValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.SymbolScopeValue;

public class LabelDirective
extends AsmDirective {
    private boolean dontInsertLabelInScope = false;
    private String name;

    public LabelDirective(String name, DebugInfo debug) {
        super(debug);
        this.name = name;
    }

    public void setDontInsertLabelInScope(boolean b) {
        this.dontInsertLabelInScope = b;
    }

    public AsmNode copy() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public AsmNode parse(EvaluationState state) {
        Integer pc = state.getMemoryPosition();
        if (pc == null) {
            return this;
        }
        SymbolScope symbolScope = state.getCurrentScope().getSymbols();
        LabelReferenceValue labelReference = (LabelReferenceValue)symbolScope.getLocalDefinedEntities().get(this.name);
        NumberValue pcValue = new NumberValue(pc.intValue());
        labelReference.setResolvedLabelValue(pcValue, state, this.debug);
        state.setMadeMetaProgress();
        return EmptyOutput.instance;
    }

    public AsmNode preParse(EvaluationState state) {
        SymbolScope symbolScope = state.getCurrentScope().getSymbols();
        SymbolScopeValue existingSymbol = (SymbolScopeValue)symbolScope.getLocalDefinedEntities().get(this.name);
        if (existingSymbol != null) {
            throw new AsmError("The symbol '" + this.name + "' is already defined", this.debug);
        }
        if (!this.dontInsertLabelInScope) {
            symbolScope.put(this.name, new LabelReferenceValue());
        }
        return this;
    }

    public String toString() {
        return "Label(" + this.name + ")";
    }
}

