/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.EntityScope;

public class MacroDefinition
extends AsmDirective {
    private String name;
    private ExecutableDirectives macro;

    public MacroDefinition(String name, ExecutableDirectives macro, DebugInfo debug) {
        super(debug);
        this.name = name;
        this.macro = macro;
    }

    public AsmNode copy() {
        return this;
    }

    public AsmNode parse(EvaluationState state) throws AsmException {
        throw ShouldNotBeHereException.instance;
    }

    public AsmNode preParse(EvaluationState state) {
        EntityScope<ExecutableDirectives> macroScope = state.getCurrentScope().getMacros();
        if (macroScope.getLocalDefinedEntities().containsKey(this.name)) {
            throw new AsmError("The macro '" + this.name + "'  is already defined", this.debug);
        }
        macroScope.put(this.name, this.macro);
        state.setMadeMetaProgress();
        return EmptyOutput.instance;
    }
}

