/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.metanodes.ArgumentAssignmentNode;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.state.EvaluationState;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroExecution
extends AsmDirective {
    private String name;
    private List<ExprNode> argumentExprs;

    public MacroExecution(String name, List<ExprNode> argumentExprs, DebugInfo debug) {
        super(debug);
        this.name = name;
        this.argumentExprs = argumentExprs;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState state) throws AsmException {
        ExecutableDirectives macro = state.getCurrentScope().getMacros().get(this.name);
        if (macro == null) {
            throw new AsmError("Macro command  '" + this.name + "' not defined", this.debug);
        }
        List<String> argumentNames = macro.getArgumentNames();
        if (argumentNames.size() != this.argumentExprs.size()) {
            throw new AsmError("Invalid number of arguments for macro", this.debug);
        }
        AsmNode node = new AsmNodeList(macro.getCopyOfDirectives());
        node = new ArgumentAssignmentNode(macro.getArgumentNames(), this.argumentExprs, node, null, this.debug);
        node = new ScopeNode(node, null, true, this.debug);
        return node.preParse(state).parse(state);
    }
}

