/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.StartOfMemoryBlockOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class MemoryBlockDirective
extends AsmDirective {
    private DebugInfo debug;
    private ExprNode startAddressExpr;
    private String virtualStr;
    private String name;

    public MemoryBlockDirective(ExprNode startAddress, String name, String virtualStr, DebugInfo debug) {
        super(debug);
        this.startAddressExpr = startAddress;
        this.virtualStr = virtualStr;
        this.name = name == null ? "Unnamed" : name;
    }

    public AsmNode copy() {
        return this;
    }

    public AsmNode parse(EvaluationState state) {
        boolean virtual;
        if (state.getPseudoPcMode()) {
            throw new AsmError("You cant define a memoryblock inside the scope of a pseudopc directive", this.debug);
        }
        state.clearFunctionSideOutput();
        Value addressValue = this.startAddressExpr.evaluate(state);
        if (addressValue.isInvalid()) {
            return this.invalidatePcAndReturnThis(state);
        }
        int address = addressValue.getInt(this.debug);
        if (this.virtualStr == null) {
            virtual = false;
        } else if (this.virtualStr.equals("virtual")) {
            virtual = true;
        } else {
            throw new AsmError("Invalid argument: " + this.virtualStr, this.debug);
        }
        state.setMemoryPosition(address);
        if (state.getErrrorDuringFunctionEvaluation()) {
            return this;
        }
        return new StartOfMemoryBlockOutput(address, this.name, virtual, state.getFunctionSideOutput());
    }
}

