/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.MultiLabelReferenceValue;
import cml.kickass.values.NumberValue;

public class MultiLabelDirective
extends AsmDirective {
    private String name;
    private Integer multiLabelIndex;

    public MultiLabelDirective(String name, DebugInfo debug) {
        super(debug);
        this.name = name;
    }

    public AsmNode copy() {
        return new MultiLabelDirective(this.name, this.debug);
    }

    public AsmNode parse(EvaluationState state) {
        state.clearFunctionSideOutput();
        SymbolScope symbolScope = state.getCurrentScope().getSymbols();
        MultiLabelReferenceValue labelReference = (MultiLabelReferenceValue)symbolScope.getLocalDefinedEntities().get(this.name);
        labelReference.setMultiLabelIndex(this.multiLabelIndex, state);
        Integer pc = state.getMemoryPosition();
        if (pc == null) {
            return this;
        }
        NumberValue pcValue = new NumberValue(pc.intValue());
        labelReference.setResolvedLabelValue(pcValue, state, this.debug);
        state.setMadeMetaProgress();
        return new SideEffectOnlyOutput(state.getFunctionSideOutput());
    }

    public AsmNode preParse(EvaluationState state) {
        SymbolScope symbolScope = state.getCurrentScope().getSymbols();
        MultiLabelReferenceValue multiLabelReference = (MultiLabelReferenceValue)symbolScope.getLocalDefinedEntities().get(this.name);
        if (multiLabelReference == null) {
            multiLabelReference = new MultiLabelReferenceValue();
            symbolScope.put(this.name, multiLabelReference);
        }
        this.multiLabelIndex = multiLabelReference.addMultiLabel();
        return this;
    }

    public String toString() {
        return "MultiLabel(" + this.name + ")";
    }
}

