/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.EntityScope;

public class PseudoCommandDefinition
extends AsmDirective {
    private String name;
    private ExecutableDirectives pseudoCmd;

    public PseudoCommandDefinition(String name, ExecutableDirectives pseudoCmd, DebugInfo debug) {
        super(debug);
        this.name = name;
        this.pseudoCmd = pseudoCmd;
    }

    public AsmNode copy() {
        return this;
    }

    public AsmNode parse(EvaluationState state) throws AsmException {
        throw ShouldNotBeHereException.instance;
    }

    public AsmNode preParse(EvaluationState state) throws AsmException {
        EntityScope<ExecutableDirectives> pseudoCmdScope = state.getCurrentScope().getPseudoCommands();
        if (pseudoCmdScope.getLocalDefinedEntities().containsKey(this.name)) {
            throw new AsmError("The pseudo command '" + this.name + "'  is already defined", this.debug);
        }
        pseudoCmdScope.put(this.name, this.pseudoCmd);
        state.setMadeMetaProgress();
        return EmptyOutput.instance;
    }
}

