/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.metanodes.ArgumentAssignmentNode;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.AsmCommandArgumentValue;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoCommandExecution
extends AsmDirective {
    private String name;
    private List<ExprNode> argumentExprs;

    public PseudoCommandExecution(String name, List<ExprNode> argumentExprs, DebugInfo debug) {
        super(debug);
        this.name = name;
        this.argumentExprs = argumentExprs;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState state) throws AsmException {
        ExecutableDirectives pseudoCmd = state.getCurrentScope().getPseudoCommands().get(this.name);
        if (pseudoCmd == null) {
            throw new AsmError("Pseudo command  '" + this.name + "' not defined", this.debug);
        }
        List<String> argumentNames = pseudoCmd.getArgumentNames();
        if (argumentNames.size() < this.argumentExprs.size() && (argumentNames.size() != 0 || this.argumentExprs.size() != 1)) {
            throw new AsmError("Too many arguments for pseudo command", this.debug);
        }
        AsmNode node = new AsmNodeList(pseudoCmd.getCopyOfDirectives());
        node = new ArgumentAssignmentNode(pseudoCmd.getArgumentNames(), this.argumentExprs, node, AsmCommandArgumentValue.noArgument, this.debug);
        node = new ScopeNode(node, null, true, this.debug);
        return node.preParse(state).parse(state);
    }
}

