/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class PseudoPCDirective
extends AsmDirective {
    private ExprNode orgAddressExpr;
    private AsmNode body;
    boolean preParsed = false;
    boolean functionsEvalOk = false;

    public PseudoPCDirective(ExprNode orgAddressExpr, AsmNode body, DebugInfo debugInfo) {
        super(debugInfo);
        this.orgAddressExpr = orgAddressExpr;
        this.body = body;
    }

    public AsmNode copy() {
        return new PseudoPCDirective(this.orgAddressExpr, this.body.copy(), this.debug);
    }

    public boolean isFinished() {
        return this.functionsEvalOk && this.body.isFinished();
    }

    public void deliverOutput(OutputReciever reciever) {
        this.body.deliverOutput(reciever);
    }

    public AsmNode parse(EvaluationState state) {
        if (state.getPseudoPcMode()) {
            throw new AsmError("You cant nest pseudo pc directives", this.debug);
        }
        state.clearFunctionSideOutput();
        Value orgAddressValue = this.orgAddressExpr.evaluate(state);
        if (orgAddressValue.isInvalid()) {
            this.invalidatePcAndReturnThis(state);
        }
        int orgAddress = orgAddressValue.getInt(this.debug);
        Integer realMememoryPosition = state.getMemoryPosition();
        state.setMemoryPosition(orgAddress);
        state.setRealMemoryPosition(realMememoryPosition);
        state.setPseudoPcMode(true);
        if (!this.preParsed) {
            this.body = this.body.preParse(state);
        }
        this.body = this.body.parse(state);
        state.setPseudoPcMode(false);
        state.setMemoryPosition(state.getRealMemoryPosition());
        this.functionsEvalOk = !state.getErrrorDuringFunctionEvaluation();
        return this;
    }
}

