/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.StructValue;
import cml.kickass.values.Value;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructDirective
extends AsmDirective {
    private String name;
    private List<String> variableNames;

    public StructDirective(String name, List<String> variableNames, DebugInfo debug) {
        super(debug);
        this.name = name;
        this.variableNames = variableNames;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState state) {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public AsmNode preParse(EvaluationState state) {
        boolean functionExist = state.getFunctionTable().exist(this.name, null);
        if (functionExist) {
            throw new AsmError("Can't define constructor for the struct '" + this.name + "'. The function name is already used", this.debug);
        }
        StructConstructor constructor = new StructConstructor(this.name, this.variableNames);
        state.getFunctionTable().add(constructor);
        return EmptyOutput.instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StructConstructor
    extends Function {
        private List<String> variableNames;

        public StructConstructor(String name, List<String> variableNames) {
            super(name, null, null, true);
            this.variableNames = variableNames;
        }

        @Override
        public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) throws AsmException {
            StructValue value = null;
            if (arguments.length == 0) {
                value = new StructValue(this.getName(), this.variableNames, null);
            }
            if (arguments.length == this.variableNames.size()) {
                value = new StructValue(this.getName(), this.variableNames, arguments);
            }
            if (value == null) {
                throw new AsmError("Invalid number of arguments for struct constructor", debug);
            }
            return value;
        }
    }
}

