/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.CharToPetsciiConverter;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class TextBlockDirective
extends AsmDirective {
    private ExprNode stringExpr;

    public TextBlockDirective(ExprNode stringExpr, DebugInfo debug) {
        super(debug);
        this.stringExpr = stringExpr;
    }

    public AsmNode copy() {
        return this;
    }

    public AsmNode parse(EvaluationState state) {
        state.clearFunctionSideOutput();
        Value stringValue = this.stringExpr.evaluate(state);
        if (stringValue.isInvalid()) {
            return this;
        }
        String str = stringValue.getString(this.debug);
        byte[] byteCode = new byte[str.length()];
        int i = 0;
        while (i < byteCode.length) {
            byteCode[i] = CharToPetsciiConverter.convert(str.charAt(i), true);
            ++i;
        }
        state.increaseMemoryPosition(str.length());
        if (state.getErrrorDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(byteCode, state.getFunctionSideOutput());
    }
}

