/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ReturnException;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.state.scope.StdScope;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.NullValue;
import cml.kickass.values.Value;
import cml.kickass.values.VariableReferenceValue;
import java.util.List;

class UserFunction
extends Function {
    private List<String> argumentNames;
    private List<AsmNode> body;

    protected UserFunction(String name, ExecutableDirectives function) {
        super(name, function.getArgumentNames().size(), null, true);
        this.argumentNames = function.getArgumentNames();
        this.body = function.getDirectives();
    }

    public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) throws AsmException {
        Scope outerScope = state.getCurrentScope();
        Scope outerScopeBeforeFunctionMode = state.getScopeBeforeFunctionMode();
        boolean outerFunctionMode = state.getFunctionsMode();
        Scope scopeBeforeFunctionMode = outerScopeBeforeFunctionMode;
        if (scopeBeforeFunctionMode == null) {
            scopeBeforeFunctionMode = state.getCurrentScope();
            state.setScopeBeforeFunctionMode(scopeBeforeFunctionMode);
        }
        StdScope scope = new StdScope(scopeBeforeFunctionMode, false);
        state.setCurrentScope(scope);
        SymbolScope symbolScope = scope.getSymbols();
        int i = 0;
        while (i < arguments.length) {
            VariableReferenceValue value = new VariableReferenceValue(arguments[i]);
            symbolScope.put(this.argumentNames.get(i), value);
            ++i;
        }
        state.setFunctionMode(true);
        Value returnValue = NullValue.instance;
        try {
            for (AsmNode node : this.body) {
                node.functionParse(state);
            }
        }
        catch (ReturnException ex) {
            returnValue = ex.getReturnValue();
        }
        state.setFunctionMode(outerFunctionMode);
        state.setCurrentScope(outerScope);
        state.setScopeBeforeFunctionMode(outerScopeBeforeFunctionMode);
        return returnValue;
    }
}

