/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.AsmCommandArgumentValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;

public class AsmCommandArgExpr
extends ExprNode {
    private static final AsmCommandArgumentValue noneArgValue = new AsmCommandArgumentValue(0, NumberValue.zero);
    private ExprNode valueExpr;
    private int mode;
    private boolean dereference;

    public AsmCommandArgExpr(int mode, ExprNode valueExpr) {
        this(mode, valueExpr, false);
    }

    public AsmCommandArgExpr(int mode, ExprNode valueExpr, boolean dereference) {
        super(valueExpr == null ? null : valueExpr.getDebugInfo());
        this.valueExpr = valueExpr;
        this.mode = mode;
        this.dereference = dereference;
    }

    public Value evaluate(EvaluationState state) {
        if (this.mode == 0) {
            return noneArgValue;
        }
        Value value = this.valueExpr.evaluate(state);
        if (this.dereference && value.hasRepresentation(Value.RP_ASMARGVALUE)) {
            return value;
        }
        if (!value.isInvalid() && !value.hasRepresentation(Value.RP_DOUBLEVALUE)) {
            throw new AsmError("The value of a Command Argument Value must be an integer. This expression returns a value of type '" + value.getType() + "'", this.debug);
        }
        return new AsmCommandArgumentValue(this.mode, value);
    }
}

