/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SESymbolDeclaration;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.ConstantReferenceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;

public class ConstDeclaration
extends ExprNode {
    private String name;
    private ExprNode expr;

    public ConstDeclaration(String name, ExprNode expr, DebugInfo debug) {
        super(debug);
        this.name = name;
        this.expr = expr;
    }

    public Value evaluate(EvaluationState state) {
        SymbolScope symbolScope = state.getCurrentScope().getSymbols();
        SymbolScopeValue existingSymbol = (SymbolScopeValue)symbolScope.getLocalDefinedEntities().get(this.name);
        if (existingSymbol != null) {
            throw new AsmError("The symbol '" + this.name + "' is already defined", this.debug);
        }
        Value value = this.expr.evaluate(state).deReference();
        if (value.hasInvalidContent()) {
            state.setErrrorDuringFunctionEvaluation(true);
        }
        ConstantReferenceValue constantReference = new ConstantReferenceValue(value);
        symbolScope.put(this.name, constantReference);
        if (!state.getFunctionsMode()) {
            SESymbolDeclaration sideEffect = new SESymbolDeclaration(this.name, constantReference, value);
            state.addSideEffect(sideEffect);
        }
        return constantReference;
    }

    public String toString() {
        return "ConstDeclaration";
    }
}

