/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.DebugTokenValue;
import cml.kickass.sideeffect.SESymbolDeclaration;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.ConstantReferenceValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumDeclaration
extends ExprNode {
    private List<Object[]> enumList;

    public EnumDeclaration(List<Object[]> enumList, DebugInfo debug) {
        super(debug);
        this.enumList = enumList;
    }

    @Override
    public Value evaluate(EvaluationState state) throws AsmException {
        SymbolScope symbolScope = state.getCurrentScope().getSymbols();
        int enumNumber = 0;
        for (Object[] constant : this.enumList) {
            Value value;
            DebugInfo debug = ((DebugTokenValue)constant[0]).getDebugInfo();
            String name = ((DebugTokenValue)constant[0]).getString();
            ExprNode expr = (ExprNode)constant[1];
            if (symbolScope.getLocalDefinedEntities().get(name) != null) {
                throw new AsmError("The symbol '" + name + "' is already defined", debug);
            }
            if (expr == null) {
                value = new NumberValue(enumNumber++);
            } else {
                value = expr.evaluate(state).deReference();
                if (value.hasInvalidContent()) {
                    state.setErrrorDuringFunctionEvaluation(true);
                }
            }
            ConstantReferenceValue constantReference = new ConstantReferenceValue(value);
            symbolScope.put(name, constantReference);
            if (state.getFunctionsMode()) continue;
            SESymbolDeclaration sideEffect = new SESymbolDeclaration(name, constantReference, value);
            state.addSideEffect(sideEffect);
        }
        return NullValue.instance;
    }
}

