/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ReturnException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCall
extends ExprNode {
    private String functionName;
    private ArrayList<ExprNode> argExprs;

    public FunctionCall(String functionName, ArrayList<ExprNode> argExprs, DebugInfo debug) {
        super(debug);
        this.argExprs = argExprs;
        this.functionName = functionName;
    }

    @Override
    public Value evaluate(EvaluationState state) throws AsmException {
        Value result;
        Value[] args = new Value[this.argExprs.size()];
        boolean invalidArgs = false;
        int i = 0;
        while (i < args.length) {
            Value value = this.argExprs.get(i).evaluate(state).deReference();
            invalidArgs |= value.isInvalid();
            args[i] = value;
            ++i;
        }
        Function function = state.getFunctionTable().get(this.functionName, args, this.debug);
        state.getCallStack().push(this.debug);
        try {
            result = invalidArgs && !function.handlesInvalidArguments() ? function.getInvalidResult(args) : function.execute(args, state, this.debug);
        }
        catch (ReturnException re) {
            result = re.getReturnValue();
        }
        state.getCallStack().pop();
        return result;
    }

    public String toString() {
        return String.valueOf(this.functionName) + "()";
    }
}

