/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;

public class MultiLabelReference
extends ExprNode {
    private String fullName;
    private String name;
    private int relativeIndex;

    public MultiLabelReference(String name, DebugInfo debug) {
        super(debug);
        this.fullName = name;
        if (name.endsWith("-")) {
            this.relativeIndex = 0;
        } else if (name.endsWith("+")) {
            this.relativeIndex = 1;
        } else {
            throw new AsmError("Missing direction on multilabel reference '" + name + "'", debug);
        }
        this.name = name.substring(0, name.length() - 1);
    }

    public Value evaluate(EvaluationState state) throws AsmException {
        SymbolScopeValue value = state.getCurrentScope().getSymbols().getMultiLabelValue(this.name, this.relativeIndex);
        if (value == null) {
            throw new AsmError("Unknown symbol '" + this.fullName + "'", this.debug);
        }
        return value;
    }

    public String toString() {
        return "MultiLabelReference(" + this.fullName + ")";
    }
}

