/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.expressions.ExprNode;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjFunctionCall
extends ExprNode {
    private String functionName;
    private ExprNode[] objAndArgumentExprs;

    public ObjFunctionCall(String functionName, DebugInfo debug, ExprNode objExpr, ExprNode ... argumentExprs) {
        super(debug);
        this.functionName = functionName;
        this.objAndArgumentExprs = new ExprNode[argumentExprs.length + 1];
        this.objAndArgumentExprs[0] = objExpr;
        int i = 0;
        while (i < argumentExprs.length) {
            this.objAndArgumentExprs[i + 1] = argumentExprs[i];
            ++i;
        }
    }

    public ObjFunctionCall(String functionName, DebugInfo debug, ExprNode objExpr, ArrayList<ExprNode> argumentExprs) {
        this(functionName, debug, objExpr, ObjFunctionCall.toArray(argumentExprs));
    }

    private static ExprNode[] toArray(List<ExprNode> list) {
        int noOfArgs = list.size();
        ExprNode[] array = new ExprNode[noOfArgs];
        int i = 0;
        while (i < noOfArgs) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    @Override
    public Value evaluate(EvaluationState state) {
        boolean invalidValues = false;
        Value[] arguments = new Value[this.objAndArgumentExprs.length];
        Value object = null;
        int i = 0;
        while (i < this.objAndArgumentExprs.length) {
            Value argument = this.objAndArgumentExprs[i].evaluate(state);
            if (i == 0) {
                object = argument;
            }
            arguments[i] = argument.deReference();
            if (argument.isInvalid()) {
                invalidValues = true;
            }
            ++i;
        }
        Function function = object.getFunctions().get(this.functionName, arguments, this.debug);
        if (invalidValues && !function.handlesInvalidArguments()) {
            return function.getInvalidResult(arguments);
        }
        state.getCallStack().push(this.debug);
        Value result = function.execute(arguments, state, this.debug);
        state.getCallStack().pop();
        return result;
    }

    public String toString() {
        return "obj." + this.functionName + "()";
    }
}

