/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class ObjVariableReference
extends ExprNode {
    private ExprNode expr;
    private String varName;

    public ObjVariableReference(ExprNode expr, String varName, DebugInfo debug) {
        super(debug);
        this.varName = varName;
        this.expr = expr;
    }

    public Value evaluate(EvaluationState state) throws AsmException {
        Value objValue = this.expr.evaluate(state);
        Value returnValue = objValue.getVariable(this.varName, this.debug);
        if (returnValue == null) {
            throw new AsmError("undefined object variable: " + this.varName, this.debug);
        }
        return returnValue;
    }
}

