/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SESymbolDeclaration;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.FunctionVariableReferenceValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.ReferenceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;
import cml.kickass.values.VariableReferenceValue;

public class VariableDeclaration
extends ExprNode {
    private String name;
    private static final Value initValue = NullValue.instance;

    public VariableDeclaration(String name, DebugInfo debug) {
        super(debug);
        this.name = name;
    }

    public Value evaluate(EvaluationState state) throws AsmException {
        ReferenceValue variableReference;
        SymbolScope symbolScope = state.getCurrentScope().getSymbols();
        SymbolScopeValue existingSymbol = (SymbolScopeValue)symbolScope.getLocalDefinedEntities().get(this.name);
        if (existingSymbol != null) {
            throw new AsmError("The symbol '" + this.name + "' is already defined", this.debug);
        }
        if (state.getFunctionsMode()) {
            variableReference = new FunctionVariableReferenceValue(initValue);
        } else {
            variableReference = new VariableReferenceValue(initValue);
            SESymbolDeclaration sideEffect = new SESymbolDeclaration(this.name, variableReference, initValue);
            state.addSideEffect(sideEffect);
        }
        symbolScope.put(this.name, variableReference);
        return variableReference;
    }

    public String toString() {
        return "VarDeclaration";
    }
}

