/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class VariableReference
extends ExprNode {
    private String name;

    public VariableReference(String name, DebugInfo debug) {
        super(debug);
        this.name = name;
    }

    public Value evaluate(EvaluationState state) throws AsmException {
        Value value = (Value)state.getCurrentScope().getSymbols().get(this.name);
        if (value == null) {
            throw new AsmError("Unknown symbol '" + this.name + "'", this.debug);
        }
        if (value.isInvalid()) {
            if (state.failOnInvalidValue()) {
                throw new AsmError("Cant resolve invalid value '" + this.name + "'", this.debug);
            }
            state.setErrrorDuringFunctionEvaluation(true);
        }
        return value;
    }

    public String toString() {
        return "VarReference(" + this.name + ")";
    }
}

