/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.function.table;

import cml.kickass.exceptions.AsmError;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.values.Value;
import java.util.HashMap;
import java.util.Map;

public class StdFunctionTable
extends FunctionTable {
    private static Integer anyNoOfArguments = -1;
    private Map<String, Map<Integer, Function>> functionMap = new HashMap<String, Map<Integer, Function>>();

    public StdFunctionTable() {
    }

    public StdFunctionTable(StdFunctionTable functionTable) {
        this.functionMap.putAll(functionTable.functionMap);
    }

    public void add(Function function, DebugInfo debug) {
        Integer argKey;
        String name = function.getName();
        Map<Integer, Function> functionVariants = this.functionMap.get(name);
        if (functionVariants == null) {
            functionVariants = new HashMap<Integer, Function>();
            this.functionMap.put(name, functionVariants);
        }
        Integer n = argKey = function.getNoOfArguments() == null ? anyNoOfArguments : function.getNoOfArguments();
        if (functionVariants.containsKey(argKey)) {
            throw new AsmError("The function '" + name + "' is already defined.", debug);
        }
        functionVariants.put(argKey, function);
    }

    public Function get(String name, Value[] args, DebugInfo debug) {
        Function function;
        Map<Integer, Function> functionVariants = this.functionMap.get(name);
        if (functionVariants == null) {
            throw new AsmError("Unknown function : " + name, debug);
        }
        Function function2 = function = args == null ? null : functionVariants.get(args.length);
        if (function == null) {
            function = functionVariants.get(anyNoOfArguments);
        }
        if (function == null) {
            throw new AsmError("Invalid number of arguments : " + name, debug);
        }
        return function;
    }

    public boolean exist(String name, Value[] args) {
        Map<Integer, Function> functionVariants = this.functionMap.get(name);
        if (functionVariants == null) {
            return false;
        }
        if (args == null) {
            return true;
        }
        Function function = functionVariants.get(args.length);
        return function != null;
    }
}

