/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.lexvalues;

import cml.kickass.state.CallStack;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class DebugInfo {
    private int line;
    private int column;
    private String filename;
    private DebugInfo parrent;

    public DebugInfo(int line, int collumn, String filename, DebugInfo parrent) {
        this.line = line;
        this.column = collumn;
        this.filename = filename;
        this.parrent = parrent;
    }

    public void setColumn(int _column) {
        this.column = _column;
    }

    public String getInclusionTrace() {
        String newln = System.getProperties().getProperty("line.separator");
        StringBuffer res = new StringBuffer();
        res.append(this.getPositionString());
        res.append(newln);
        if (this.parrent != null) {
            res.append("- included " + this.parrent.getInclusionTrace());
        }
        return res.toString();
    }

    public String getPositionString() {
        StringBuffer res = new StringBuffer();
        if (this.line >= 0) {
            res.append("at line " + (this.line + 1));
            if (this.column >= 0) {
                res.append(", column " + (this.column + 1) + " ");
            }
        }
        if (this.filename != null) {
            res.append("in " + this.filename);
        }
        return res.toString();
    }

    public String getMarkedErrorLine() {
        String newln = System.getProperties().getProperty("line.separator");
        StringBuffer s = new StringBuffer();
        s.append(this.removeTabs(this.getLinesInFile(this.line - 3, this.line - 1, this.filename)));
        if (this.column < 0) {
            s.append(">>>");
        }
        s.append(this.removeTabs(this.getLinesInFile(this.line, this.line, this.filename)));
        if (this.column >= 0) {
            int i = 0;
            while (i < this.column) {
                s.append(' ');
                ++i;
            }
            s.append(String.valueOf('^') + newln);
        }
        return s.toString();
    }

    private String getLinesInFile(int startLine, int endLine, String filename) {
        String newln = System.getProperties().getProperty("line.separator");
        try {
            StringBuffer res = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            int i = 0;
            while (i < startLine) {
                in.readLine();
                ++i;
            }
            while (i <= endLine) {
                res.append(String.valueOf(in.readLine()) + newln);
                ++i;
            }
            return res.toString();
        }
        catch (Exception ex) {
            return "Error - End of file reached";
        }
    }

    private String removeTabs(String string) {
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c != '\t') {
                res.append(c);
            } else {
                res.append(' ');
            }
            ++i;
        }
        return res.toString();
    }

    public String getFormattedErrorMessage(String message, CallStack callStack) {
        String newln = System.getProperties().getProperty("line.separator");
        String trace = callStack == null ? this.getInclusionTrace() : callStack.getTrace(this);
        return String.valueOf(this.getMarkedErrorLine()) + newln + "Error: " + message + newln + trace + newln;
    }

    public String getFormattedErrorMessage(String message) {
        return this.getFormattedErrorMessage(message, null);
    }
}

