/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.libraries;

import cml.kickass.constant.Constant;
import cml.kickass.exceptions.AsmError;
import cml.kickass.function.DoubleFunction;
import cml.kickass.function.DoubleX2Function;
import cml.kickass.function.Function;
import cml.kickass.function.LongFunction;
import cml.kickass.function.LongX2DebugFunction;
import cml.kickass.function.VoidFunction;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.libraries.Library;
import cml.kickass.values.NullValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathLibrary
implements Library {
    private static Random randomGenerator = new Random(0L);

    public static void setSeed(long seed) {
        randomGenerator.setSeed(seed);
    }

    public static Random getRandomGenerator() {
        return randomGenerator;
    }

    public List<Constant> getConstants() {
        ArrayList<Constant> constants = new ArrayList<Constant>();
        constants.add(new Constant("PI", new NumberValue(Math.PI)));
        constants.add(new Constant("E", new NumberValue(Math.E)));
        return constants;
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        functions.add(new DoubleFunction("abs", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.abs(a));
            }
        });
        functions.add(new DoubleFunction("acos", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.acos(a));
            }
        });
        functions.add(new DoubleFunction("asin", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.asin(a));
            }
        });
        functions.add(new DoubleFunction("atan", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.atan(a));
            }
        });
        functions.add(new DoubleX2Function("atan2", (Value)NumberValue.invalid){

            protected Value f(double a, double b) {
                return new NumberValue(Math.atan2(a, b));
            }
        });
        functions.add(new DoubleFunction("cbrt", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.cbrt(a));
            }
        });
        functions.add(new DoubleFunction("ceil", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.ceil(a));
            }
        });
        functions.add(new DoubleFunction("cos", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.cos(a));
            }
        });
        functions.add(new DoubleFunction("cosh", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.cosh(a));
            }
        });
        functions.add(new DoubleFunction("exp", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.exp(a));
            }
        });
        functions.add(new DoubleFunction("expm1", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.expm1(a));
            }
        });
        functions.add(new DoubleFunction("floor", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.floor(a));
            }
        });
        functions.add(new DoubleX2Function("hypot", (Value)NumberValue.invalid){

            protected Value f(double a, double b) {
                return new NumberValue(Math.hypot(a, b));
            }
        });
        functions.add(new DoubleX2Function("IEEEremainder", (Value)NumberValue.invalid){

            protected Value f(double a, double b) {
                return new NumberValue(Math.IEEEremainder(a, b));
            }
        });
        functions.add(new DoubleFunction("log", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.log(a));
            }
        });
        functions.add(new DoubleFunction("log10", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.log10(a));
            }
        });
        functions.add(new DoubleFunction("log1p", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.log1p(a));
            }
        });
        functions.add(new DoubleX2Function("max", (Value)NumberValue.invalid){

            protected Value f(double a, double b) {
                return new NumberValue(Math.max(a, b));
            }
        });
        functions.add(new DoubleX2Function("min", (Value)NumberValue.invalid){

            protected Value f(double a, double b) {
                return new NumberValue(Math.min(a, b));
            }
        });
        functions.add(new DoubleX2Function("pow", (Value)NumberValue.invalid){

            protected Value f(double a, double b) {
                return new NumberValue(Math.pow(a, b));
            }
        });
        functions.add(new VoidFunction("random", (Value)NumberValue.invalid){

            protected Value f() {
                return new NumberValue(randomGenerator.nextDouble());
            }
        });
        functions.add(new DoubleFunction("round", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.rint(a));
            }
        });
        functions.add(new DoubleFunction("signum", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.signum(a));
            }
        });
        functions.add(new DoubleFunction("sin", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.sin(a));
            }
        });
        functions.add(new DoubleFunction("sinh", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.sinh(a));
            }
        });
        functions.add(new DoubleFunction("sqrt", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.sqrt(a));
            }
        });
        functions.add(new DoubleFunction("tan", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.tan(a));
            }
        });
        functions.add(new DoubleFunction("tanh", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.tanh(a));
            }
        });
        functions.add(new DoubleFunction("toDegrees", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.toDegrees(a));
            }
        });
        functions.add(new DoubleFunction("toRadians", (Value)NumberValue.invalid){

            protected Value f(double a) {
                return new NumberValue(Math.toRadians(a));
            }
        });
        functions.add(new LongX2DebugFunction("mod", (Value)NumberValue.invalid){

            protected Value f(long a, long b, DebugInfo debug) {
                if (b == 0L) {
                    throw new AsmError("The second argument of the mod function cant be zero", debug);
                }
                return new NumberValue(a % b);
            }
        });
        functions.add(new LongFunction("setSeed", (Value)NullValue.instance){

            protected Value f(long a) {
                randomGenerator.setSeed(a);
                return NullValue.instance;
            }
        });
        return functions;
    }
}

