/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.libraries;

import cml.kickass.constant.Constant;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.libraries.AbstractLibrary;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BinaryFileValue;
import cml.kickass.values.PictureValue;
import cml.kickass.values.SidFileValue;
import cml.kickass.values.StringValue;
import cml.kickass.values.Value;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscLibrary
extends AbstractLibrary {
    public List<Constant> getConstants() {
        ArrayList<Constant> constants = new ArrayList<Constant>();
        constants.add(new Constant("BF_C64FILE", new StringValue("C64FILE")));
        constants.add(new Constant("BF_KOALA", new StringValue("C64FILE, Bitmap=$0000, ScreenRam=$1f40, ColorRam=$2328, BackgroundColor = $2710")));
        constants.add(new Constant("BF_FLI", new StringValue("C64FILE, ColorRam=$0000, ScreenRam=$0400, Bitmap=$2400")));
        constants.add(new Constant("BF_BITMAP_SINGLECOLOR", new StringValue("C64FILE, Bitmap=$0000, ScreenRam=$2000")));
        return constants;
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        functions.add(new Function("LoadSid", 1, SidFileValue.invalid){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                return MiscLibrary.loadSid(state, arguments, debug);
            }
        });
        functions.add(new Function("LoadPicture", null, PictureValue.invalid){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                return MiscLibrary.loadPicture(state, arguments, debug);
            }
        });
        functions.add(new Function("LoadBinary", null, BinaryFileValue.invalid){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                return MiscLibrary.loadBinary(state, arguments, debug);
            }
        });
        return functions;
    }

    private static Value loadSid(EvaluationState state, Value[] arguments, DebugInfo debug) {
        int fileLength;
        String filename = arguments[0].getString(debug);
        InputStream in = state.openFile(filename, debug);
        byte[] buffer = new byte[65536];
        try {
            fileLength = in.read(buffer);
        }
        catch (IOException ex) {
            throw new AsmError("Error while reading file '" + filename + "'", debug);
        }
        byte[] fitBuffer = new byte[fileLength];
        int i = 0;
        while (i < fileLength) {
            fitBuffer[i] = buffer[i];
            ++i;
        }
        return new SidFileValue(fitBuffer);
    }

    private static Value loadPicture(EvaluationState state, Value[] arguments, DebugInfo debug) throws AsmException {
        if (arguments.length < 1 || 2 < arguments.length) {
            throw new AsmError("Invalid number of arguments", debug);
        }
        String filename = arguments[0].getString(debug);
        File file = state.getFile(filename, debug);
        int[] colorTable = null;
        if (arguments.length > 1) {
            ArrayList<Value> valueColorList = arguments[1].getList(debug);
            colorTable = new int[valueColorList.size()];
            int i = 0;
            while (i < colorTable.length) {
                colorTable[i] = valueColorList.get(i).getInt(debug);
                ++i;
            }
        }
        BufferedImage img = null;
        try {
            img = ImageIO.read(file);
        }
        catch (Exception i) {
            // empty catch block
        }
        if (img == null) {
            throw new AsmError("Couldnt load image file '" + filename + "'", debug);
        }
        try {
            MediaTracker tracker = new MediaTracker(new JPanel());
            tracker.addImage(img, 0);
            tracker.waitForAll();
        }
        catch (InterruptedException ex) {
            throw new AsmError("Error while loading image file '" + filename + "'", debug);
        }
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (Exception ex) {
            new AsmError("Error while grapping pixels: " + ex.getMessage(), debug);
        }
        return new PictureValue(width, height, pixels, colorTable);
    }

    private static Value loadBinary(EvaluationState state, Value[] arguments, DebugInfo debug) throws AsmException {
        int fileLength;
        if (arguments.length < 1 || 2 < arguments.length) {
            throw new AsmError("Invalid number of arguemnts", debug);
        }
        String filename = arguments[0].getString(null);
        InputStream in = state.openFile(filename, debug);
        byte[] buffer = new byte[0x100000];
        try {
            fileLength = in.read(buffer);
        }
        catch (IOException ex) {
            throw new AsmError("Error while reading file '" + filename + "'", debug);
        }
        byte[] file = new byte[fileLength];
        int i = 0;
        while (i < fileLength) {
            file[i] = buffer[i];
            ++i;
        }
        String fileTemplate = "";
        if (arguments.length >= 2) {
            fileTemplate = arguments[1].getString(debug);
        }
        BinaryFileValue.BlockData blockData = BinaryFileValue.templateToBlocks(fileTemplate, file.length, debug);
        return new BinaryFileValue(file, blockData);
    }
}

