/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.libraries;

import cml.kickass.constant.Constant;
import cml.kickass.exceptions.AsmError;
import cml.kickass.function.Function;
import cml.kickass.function.IntFunction;
import cml.kickass.function.VoidFunction;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.libraries.Library;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.AsmCommandArgumentValue;
import cml.kickass.values.HashtableValue;
import cml.kickass.values.ListValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdConstructorLibrary
implements Library {
    public List<Constant> getConstants() {
        ArrayList<Constant> constants = new ArrayList<Constant>();
        constants.add(new Constant("AT_ABSOLUTE", new NumberValue(7.0)));
        constants.add(new Constant("AT_ABSOLUTEX", new NumberValue(8.0)));
        constants.add(new Constant("AT_ABSOLUTEY", new NumberValue(9.0)));
        constants.add(new Constant("AT_IMMEDIATE", new NumberValue(1.0)));
        constants.add(new Constant("AT_INDIRECT", new NumberValue(10.0)));
        constants.add(new Constant("AT_IZEROPAGEX", new NumberValue(5.0)));
        constants.add(new Constant("AT_IZEROPAGEY", new NumberValue(6.0)));
        constants.add(new Constant("AT_NONE", new NumberValue(0.0)));
        return constants;
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        functions.add(new VoidFunction("List", (Value)ListValue.invalid){

            protected Value f() {
                return new ListValue(0);
            }
        });
        functions.add(new IntFunction("List", (Value)ListValue.invalid){

            protected Value f(int a) {
                return new ListValue(a);
            }
        });
        functions.add(new VoidFunction("Hashtable", null){

            protected Value f() {
                return new HashtableValue();
            }
        });
        functions.add(new Function("CmdArgument", 2, null, true){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                Value typeArg = arguments[0];
                Value valueArg = arguments[1];
                if (typeArg.isInvalid()) {
                    throw new AsmError("The type is an invalid value", debug);
                }
                if (!valueArg.hasRepresentation(Value.RP_DOUBLEVALUE)) {
                    throw new AsmError("a " + typeArg.getType() + "is not a valid value argument", debug);
                }
                int type = typeArg.getInt(debug);
                return new AsmCommandArgumentValue(type, valueArg);
            }
        });
        return functions;
    }
}

